/**
 ** configx.h
 **
 ** Copyright 1990, 1991 by Randy Sargent.
 **
 ** The author hereby grants to MIT permission to use this software.
 ** The author also grants to MIT permission to distribute this software
 ** to schools for non-commercial educational use only.
 **
 ** The author hereby grants to other individuals or organizations
 ** permission to use this software for non-commercial
 ** educational use only.  This software may not be distributed to others
 ** except by MIT, under the conditions above.
 **
 ** Other than these cases, no part of this software may be used or
 ** distributed without written permission of the author.
 **
 ** Neither the author nor MIT make any representations about the 
 ** suitability of this software for any purpose.  It is provided 
 ** "as is" without express or implied warranty.
 **
 ** Randy Sargent
 ** Research Specialist
 ** MIT Media Lab
 ** 20 Ames St.  E15-301
 ** Cambridge, MA  02139
 ** E-mail:  rsargent@athena.mit.edu
 **
 **/


#ifndef CONFIGX_H
#define CONFIGX_H

#include <config.h>


#ifndef Int
#define Int long
#endif

#include <stdio.h>

#ifdef HAS_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAS_LIBC_H
#include <libc.h>
#endif
#ifdef HAS_SYS_TYPES_H
#include <sys/types.h>
#endif
#ifdef HAS_SYS_UIO_H
#include <sys/uio.h>
#endif
#ifdef HAS_STDLIB_H
#include <stdlib.h>
#endif


#include <string.h>

#ifdef HAS_TCSETATTR
#define USE_TERMIOS
#endif

#ifdef NEED_MALLOC_PROTOS
extern void *malloc (size_t size);
extern void *calloc ( size_t nmemb, size_t size);
extern void *realloc (void *ptr, size_t size);
void free (void *ptr);
#endif

#ifdef NEED_FREAD_PROTOS
Int fread(void *, Int, Int, FILE *);
#endif

#ifdef NEED_ATOF_PROTOS
extern double atof(const char *);
long strtol(char *, char **, Int);
double strtod(char *, char**);
#endif


#ifdef NEED_FILE_PROTOS
Int fread(void *, Int, Int, FILE *);
Int fseek(FILE *, long, Int);
#endif

#if 0
#define vfprintf(file,format,args) _doprnt(format,args,file)
#define HACK_VSPRINTF
Int vsprintf(char *dest, char *fmt, void *args);
void memmove(void *dest, void *src, Int len);
#endif

#ifndef FILE_DIRECTORY_DELIMITERS
#define FILE_DIRECTORY_DELIMITERS "/"
#endif

#ifndef FILE_DIRECTORY_DELIMITER
#define FILE_DIRECTORY_DELIMITER '/'
#endif

#ifndef READ_BINARY
#define READ_BINARY "r"
#endif

#ifndef READ_WRITE_BINARY
#define READ_WRITE_BINARY "r+"
#endif

#ifndef WRITE_BINARY
#define WRITE_BINARY "w"
#endif

#define YY_USE_PROTOS

#ifndef DEFAULT_SERIAL_PORT
#define DEFAULT_SERIAL_PORT ""
#endif

#ifndef LIB_DIRECTORY
#define LIB_DIRECTORY "/usr/local/lib/"
#endif

#ifndef DEFAULT_EDITOR
#define DEFAULT_EDITOR "emacs"
#endif

#ifndef MAX_ALLOCATED_DATA_SIZE
#define MAX_ALLOCATED_DATA_SIZE 4000000
#endif

#ifdef __SABER__
typedef char *va_list;
#define va_start(list, last_arg) list= sizeof(last_arg) + (char*)&last_arg
#define va_arg(list, type) (((type*)(list += sizeof(type)))[-1])
#define va_end(list)
#else
#include <stdarg.h>
#endif

#ifdef __GNUC__
/*#define HAS_INLINE*/
#endif

#ifdef HAS_INLINE
#define INLINE inline
#else
#define INLINE
#endif

void proc_printf (char *format, ...);

#include <util.h>

#endif /* #ifndef CONFIGX_H */

