/**
 ** growbuf.h
 **
 ** Copyright 1990, 1991 by Randy Sargent.
 **
 ** The author hereby grants to MIT permission to use this software.
 ** The author also grants to MIT permission to distribute this software
 ** to schools for non-commercial educational use only.
 **
 ** The author hereby grants to other individuals or organizations
 ** permission to use this software for non-commercial
 ** educational use only.  This software may not be distributed to others
 ** except by MIT, under the conditions above.
 **
 ** Other than these cases, no part of this software may be used or
 ** distributed without written permission of the author.
 **
 ** Neither the author nor MIT make any representations about the 
 ** suitability of this software for any purpose.  It is provided 
 ** "as is" without express or implied warranty.
 **
 ** Randy Sargent
 ** Research Specialist
 ** MIT Media Lab
 ** 20 Ames St.  E15-301
 ** Cambridge, MA  02139
 ** E-mail:  rsargent@athena.mit.edu
 **
 **/

/**
 **  growbuf.h
 **
 ** v1.0  Fri May 17 11:02:00 1991  Randy Sargent.  created
 ** v1.1  Sun May 26 00:39:30 1991  Randy Sargent.  added growbuf_length
 ** v1.2  Sun Sep  1 00:10:02 1991  Randy Sargent.  added add_{Int,float,...}
 **/

#ifndef GROWBUF_H
#define GROWBUF_H

typedef struct growbuf_str {
    char *buf;
    char *bufptr;
    char *bufend;
} Growbuf;

#define GROWBUF_ADD_CHAR(g,c) \
  (((g)->bufptr == (g)->bufend) ? growbuf_add_char(g,c) : (*((g)->bufptr)++ = (char)(c)))

#define GROWBUF_DATA(g) ((g)->buf)
#define GROWBUF_LENGTH(g) ((g)->bufptr - (g)->buf)

#include "growbuf.pro"

#endif   /* #ifndef GROWBUF_H */
