/**
 ** memmove.c
 **
 ** Copyright 1990, 1991 by Randy Sargent.
 **
 ** The author hereby grants to MIT permission to use this software.
 ** The author also grants to MIT permission to distribute this software
 ** to schools for non-commercial educational use only.
 **
 ** The author hereby grants to other individuals or organizations
 ** permission to use this software for non-commercial
 ** educational use only.  This software may not be distributed to others
 ** except by MIT, under the conditions above.
 **
 ** Other than these cases, no part of this software may be used or
 ** distributed without written permission of the author.
 **
 ** Neither the author nor MIT make any representations about the 
 ** suitability of this software for any purpose.  It is provided 
 ** "as is" without express or implied warranty.
 **
 ** Randy Sargent
 ** Research Specialist
 ** MIT Media Lab
 ** 20 Ames St.  E15-301
 ** Cambridge, MA  02139
 ** E-mail:  rsargent@athena.mit.edu
 **
 **/

/**
 **  memmove.c
 **
 ** v1.0  Thu May  9 08:46:43 1991  Randy Sargent.  created
 **/

#include CONFIG

#include "memmove.h"

#ifdef NEEDS_MEMMOVE
void memmove(void *dest, void *src, Int len)
{
    char *cdest= dest, *csrc= src;

    if (cdest < csrc) {
	/* Copy front to back */
	while (len--) *cdest++= *csrc++;
    }
    else {
	/* Copy back to front */
	cdest += len;
	csrc += len;
	while (len--) *--cdest= *--csrc;
    }
}
#else

void memmove_dont_be_an_empty_file(void)
{
    /* Some losing systems don't deal with an empty library file */ 
}

#endif
