/**
 ** pcodesim.h
 **
 ** Copyright 1990, 1991 by Randy Sargent.
 **
 ** The author hereby grants to MIT permission to use this software.
 ** The author also grants to MIT permission to distribute this software
 ** to schools for non-commercial educational use only.
 **
 ** The author hereby grants to other individuals or organizations
 ** permission to use this software for non-commercial
 ** educational use only.  This software may not be distributed to others
 ** except by MIT, under the conditions above.
 **
 ** Other than these cases, no part of this software may be used or
 ** distributed without written permission of the author.
 **
 ** Neither the author nor MIT make any representations about the 
 ** suitability of this software for any purpose.  It is provided 
 ** "as is" without express or implied warranty.
 **
 ** Randy Sargent
 ** Research Specialist
 ** MIT Media Lab
 ** 20 Ames St.  E15-301
 ** Cambridge, MA  02139
 ** E-mail:  rsargent@athena.mit.edu
 **
 **/


#ifndef PCODESIM_H
#define PCODESIM_H

typedef unsigned char uchar;

typedef short          int16;
typedef unsigned short intp;
typedef long           int32;
typedef float          float32;

typedef unsigned short uint16;
typedef unsigned long  uint32;

extern intp proc_current;
extern int16 proc_counter;
extern Int proc_error_flag;


extern Int pcodesim_debug;
extern Int pcodesim_major_version;
extern Int pcodesim_minor_version;

extern char *pc, *sp;
extern Int err;
extern char *mem;


#define MAX_REGS 1

#define STACK_OFFSET2(x) READ2(sp+(x))
#define STACK_OFFSET4(x) READ4(sp+(x))
#define SET_STACK_OFFSET2(x,y) WRITE2(sp+(x), (y))
#define SET_STACK_OFFSET4(x,y) WRITE4(sp+(x), (y))
#define GROW_STACK(x)  (sp -= (x))

#define MEM1(x) READ1(x+mem)
#define MEM2(x) READ2(x+mem)
#define MEM4(x) READ4(x+mem)
#define MEMP(x) READP(x+mem)

#define SET_MEM1(x,y) WRITE1((x)+mem,(y))
#define SET_MEM2(x,y) WRITE2((x)+mem,(y))
#define SET_MEM4(x,y) WRITE4((x)+mem,(y))
#define SET_MEMP(x,y) WRITEP((x)+mem,(y))

#ifndef CANT_COERCE_LVALUE
#define FETCH1 ( *(  ((char *)pc)++) )
#define READ1(x) (*(char *)(x))
#define WRITE1(x,y) ((*(char *)(x))=(y))
#else
#define FETCH1 fetch1()
#define READ1(x) read1(x)
#define WRITE1(x,y) write1(x,y)
#endif

/* Pointer operations */
#define FETCHP      ((intp)FETCH2)
#define READP(x)    ((intp)READ2(x))
#define WRITEP(x,y) (WRITE2(x,(int16)(y)))
#define PUSHP(x)    PUSH2((int16)(x))
#define POPP        (intp)POP2

#if defined(ODD_ADDRESSES_OK) && !defined(CANT_COERCE_LVALUE)

#define FETCH2 ( *(  ((int16*)pc)++) )
#define FETCH4 ( *(  ((int32*)pc)++) )

#define PUSH2(x)  ( *(--((int16  *)sp) = (x)) )
#define PUSH4(x)  ( *(--((int32  *)sp) = (x)) )
#define PUSHF(x)  ( *(--((float32*)sp) = (x)) )

#define POP2   ( *(  ((int16  *)sp)++) )
#define POP4   ( *(  ((int32  *)sp)++) )
#define POPF   ( *(  ((float32*)sp)++) )

#define READ2(x) (*(int16*)(x))
#define READ4(x) (*(int32*)(x))
#define READF(x) (*(float32*)(x))

#define WRITE2(x,y) ((*(int16*)(x))=(y))
#define WRITE4(x,y) ((*(int32*)(x))=(y))

#else

#define FETCH2 fetch2()
#define FETCH4 fetch4()

#define PUSH2(x) push2(x)
#define PUSH4(x) push4(x)
#define PUSHF(x) pushf(x)

#define POP2 pop2()
#define POP4 pop4()
#define POPF popf()

#define READ2(x) read2(x)
#define READ4(x) read4(x)
#define READF(x) readf(x)

#define WRITE2(x,y) write2(x,y)
#define WRITE4(x,y) write4(x,y)

#endif

#include "pcodesim.pro"

#endif /* #ifndef PCODESIM_H */


