/**
 ** radix.c
 **
 ** Copyright 1990, 1991 by Randy Sargent.
 **
 ** The author hereby grants to MIT permission to use this software.
 ** The author also grants to MIT permission to distribute this software
 ** to schools for non-commercial educational use only.
 **
 ** The author hereby grants to other individuals or organizations
 ** permission to use this software for non-commercial
 ** educational use only.  This software may not be distributed to others
 ** except by MIT, under the conditions above.
 **
 ** Other than these cases, no part of this software may be used or
 ** distributed without written permission of the author.
 **
 ** Neither the author nor MIT make any representations about the 
 ** suitability of this software for any purpose.  It is provided 
 ** "as is" without express or implied warranty.
 **
 ** Randy Sargent
 ** Research Specialist
 ** MIT Media Lab
 ** 20 Ames St.  E15-301
 ** Cambridge, MA  02139
 ** E-mail:  rsargent@athena.mit.edu
 **
 **/


#include CONFIG

#include <util.h>

#include "radix.h"

long radix_string_to_integer(char *token, Int default_radix)
{
    if (token[0] == '0' &&
	token[1] &&
	strchr("xdob", token[1])) {
	default_radix= token[1];
	token += 2;
    }
    switch (default_radix) {
      case 'x':
	return radix_hexadecimal_to_integer(token);
      case 'd':
	return radix_decimal_to_integer(token);
      case 'o':
	return radix_octal_to_integer(token);
      case 'b':
	return radix_binary_to_integer(token);
      default:
	die(("unknown radix >%c<", (int)default_radix));
	return 0;
    }
}

void radix_integer_to_string(char *buf, long val, Int radix)
{
    switch (radix) {
      case 'x':
	radix_integer_to_hexadecimal(buf, val);
	break;
      case 'd':
	radix_integer_to_decimal(buf, val);
	break;
      case 'o':
	radix_integer_to_octal(buf, val);
	break;
      case 'b':
	radix_integer_to_binary(buf, val);
	break;
      default:
	die(("unknown radix >%c<", (int)radix));
    }
}

long radix_hexadecimal_to_integer(char *token)
{
    long ret;
    sscanf(token, "%lx", &ret);
    return ret;
}

long radix_decimal_to_integer(char *token)
{
    long ret;
    sscanf(token, "%ld", &ret);
    return ret;
}

long radix_octal_to_integer(char *token)
{
    long ret;
    sscanf(token, "%lo", &ret);
    return ret;
}

long radix_binary_to_integer(char *token)
{
    long ret= 0;
    Int  negative= 0;
    while (*token == '-') {
	negative= !negative;
	token++;
    }
    while (*token == '0' || *token == '1') {
	ret <<= 1;
	ret= ret+ *token-'0';
	token++;
    }
    return negative ? -ret : ret;
}

void radix_integer_to_binary(char *buf, long i)
{
    unsigned long b;
    Int n;
    
    for (n= 0, b= i; b; n++, b>>=1);
    buf[n]= 0;
    for (b= i; b; n--, b>>=1) {
	buf[n-1]= (char) ((b & 1) + '0');
    }
}

void radix_integer_to_decimal(char *buf, long i)
{
    sprintf(buf, "%ld", i);
}

void radix_integer_to_octal(char *buf, long i)
{
    sprintf(buf, "%lo", i);
}

void radix_integer_to_hexadecimal(char *buf, long i)
{
    sprintf(buf, "%lx", i);
}

    
