/**
 ** runtype.h
 **
 ** Copyright 1990, 1991 by Randy Sargent.
 **
 ** The author hereby grants to MIT permission to use this software.
 ** The author also grants to MIT permission to distribute this software
 ** to schools for non-commercial educational use only.
 **
 ** The author hereby grants to other individuals or organizations
 ** permission to use this software for non-commercial
 ** educational use only.  This software may not be distributed to others
 ** except by MIT, under the conditions above.
 **
 ** Other than these cases, no part of this software may be used or
 ** distributed without written permission of the author.
 **
 ** Neither the author nor MIT make any representations about the 
 ** suitability of this software for any purpose.  It is provided 
 ** "as is" without express or implied warranty.
 **
 ** Randy Sargent
 ** Research Specialist
 ** MIT Media Lab
 ** 20 Ames St.  E15-301
 ** Cambridge, MA  02139
 ** E-mail:  rsargent@athena.mit.edu
 **
 **/

/**
 **  runtype.h
 **
 ** v1.0  Sun Jun  2 14:01:06 1991  Randy Sargent.  created
 ** v1.1  Mon Aug 12 13:35:20 1991  Randy Sargent.  added services
 **/

#ifndef RUNTYPE_H
#define RUNTYPE_H

typedef enum {
    runtype_illegal,
    runtype_list,
    runtype_symbol,
    runtype_int,
    runtype_float,
    runtype_bool,
    runtype_fixnum,
    runtype_func,
    runtype_prim,
    runtype_macro,
    runtype_spform,
    runtype_env,
    runtype_code,
    runtype_thunk,
    runtype_vector,  runtype_first_vector= runtype_vector,
    runtype_intvector,
    runtype_floatvector,
    runtype_boolvector,
    runtype_fixnumvector, runtype_last_vector= runtype_fixnumvector,
    runtype_proc,
    runtype_sequence,
    runtype_wrapper,
    runtype_any,
    runtype_max
  } Runtype;

typedef enum {
    service_display,
    service_print,
    service_gc,
    service_sprint,
    service_max
  } Service;

typedef struct generic_object_str {
    Runtype runtype;
} Generic_object;

typedef Int (*Service_func)(void *);
typedef char* (*Service_func_string)(void *);

#define RUNTYPE(x) (((Generic_object*)(x))->runtype)

#define RUNTYPE2(x,y) ((x)*256+(y))

#define RUNTYPE_IS_VECTOR_RUNTYPE(x) \
  (runtype_first_vector <= (x) && (x) <= runtype_last_vector)

#define RUNTYPE_IS_VECTOR(o) RUNTYPE_IS_VECTOR_RUNTYPE(RUNTYPE(o))
  
extern void *Illegal;
extern char *runtype_types[];
extern Int runtype_gc_debug;

#include "runtype.pro"

#endif   /* #ifndef RUNTYPE_H */




