/**
 ** scan.c
 **
 ** Copyright 1990, 1991 by Randy Sargent.
 **
 ** The author hereby grants to MIT permission to use this software.
 ** The author also grants to MIT permission to distribute this software
 ** to schools for non-commercial educational use only.
 **
 ** The author hereby grants to other individuals or organizations
 ** permission to use this software for non-commercial
 ** educational use only.  This software may not be distributed to others
 ** except by MIT, under the conditions above.
 **
 ** Other than these cases, no part of this software may be used or
 ** distributed without written permission of the author.
 **
 ** Neither the author nor MIT make any representations about the 
 ** suitability of this software for any purpose.  It is provided 
 ** "as is" without express or implied warranty.
 **
 ** Randy Sargent
 ** Research Specialist
 ** MIT Media Lab
 ** 20 Ames St.  E15-301
 ** Cambridge, MA  02139
 ** E-mail:  rsargent@athena.mit.edu
 **
 **/


#include CONFIG

#include <growbuf.h>
#include <scan.h>

Int scan_init(Scan *s, void *data, Int length)
{
    s->data=    (char*)data;
    s->dataptr= (char*)data;
    s->endptr=  length+(char*)data;
    return 0;
}

void scan_term(Scan *s)
{
    s->data= 0;
    s->dataptr= 0;
    s->endptr= 0;
}

void scan_rewind(Scan *s)
{
    s->dataptr= s->data;
}

Int scan_eof(Scan *s)
{
    return s->dataptr >= s->data;
}

int scan_get_char(Scan *s)
{
    if (s->dataptr < s->endptr) {
       /*printf("got char %c\n", *(s->dataptr));*/
       return *(s->dataptr)++;
    }
    else {
	return EOF;
    }
}

char *scan_get_string(Scan *s, char *delims)
{
    Int c;
    /* First skip delims */
    Growbuf g;
    growbuf_init(&g);
    
    while (1) {
	c= scan_get_char(s);
	if (c == EOF) return 0;
	if (!strchr(delims, c)) break;
    }

    while (1) {
	growbuf_add_char(&g, c);
	c= scan_get_char(s);
	if (c == EOF || strchr(delims, c)) break;
    }

    growbuf_add_char(&g, 0);
    return growbuf_data(&g);
}

char **scan_get_strings(Scan *s, char *delims)
{
    Growbuf g;
    growbuf_init(&g);

    while (1) {
	char *string= scan_get_string(s, delims);
	/*printf("got string %s\n", string);*/
	growbuf_add_ptr(&g, string);
	if (!string) break;
    }

    return (char**) growbuf_data(&g);
}
