
#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "xinterface.h"

Display *display;          /* pointer to the display */
Window win;                /* window to be used for graphics */
Int screen_num;            /* screen number */
Window root;               /* root window of display */
XSizeHints size_hints;     /* size hint structure for window manager */
GC the_GC;                 /* graphics context to be used */
XGCValues the_GC_values;   /* values in graphics context */
Screen *screen_point;      /* pointer to screen */
FILE *fp,*fopen();
Pixmap buff;               /* Pixmap used as drawing buffer */
XEvent event;              /* structure to hold an XEvent */

#define E_NOOPEN -1               /* error--unable to open X connection */
#define E_NOFILE -2               /* error--unable to open data file */
#define E_NOEVENTS -3             /* error--no events in file */
#define BORDER 2                  /* size of window border */

/*-------------------------------------------------------------------------*/
/*  This routine starts up the X connection, creates and maps a window,
    creates a Pixmap which gets returned to the caller and generally
    initializes things for the 1.00 student. The display pointer and the
    graphics context are returned to the user through pointer arguments */

Pixmap start_graphics(width,height,p_display,p_context)
     unsigned Int width;       /* this is the width of window */
     unsigned Int height;      /* this is the height of window */
     Display **p_display;      /* address of display pointer(returned) */
     GC *p_context;            /* pointer to graphics context(returned) */
{

/* Open display and set key variables */

  if((display=XOpenDisplay("")) == NULL)  {
    fprintf(stderr,"can't open display");
    exit(E_NOOPEN);
  }
  screen_num = DefaultScreen(display);
  root = DefaultRootWindow(display);
  screen_point = XScreenOfDisplay(display,screen_num);

/* set size hints for window manager */
  size_hints.x = 0;
  size_hints.y = 0;
  size_hints.width = width;
  size_hints.height = height;
  size_hints.flags = PSize|PPosition;

/*create the window */
  win = XCreateSimpleWindow(display,root,size_hints.x,size_hints.y,
                            size_hints.width, size_hints.height,BORDER,
                            BlackPixel(display,screen_num),
                            WhitePixel(display,screen_num));

/* set properties for window manager */
  XSetStandardProperties(display,win,"GraphicsTool","1.00 Problem Sets", None,
                         0,NULL,&size_hints);

/* elect events of interest and map window */
  XSelectInput(display,win,ExposureMask|ButtonPressMask|ButtonReleaseMask|PointerMotionMask|KeyPressMask);
  the_GC = XCreateGC(display,win,None,&the_GC_values);
  XSetGraphicsExposures(display, the_GC, False);
  XMapWindow(display,win);

/* create blanked out Pixmap buffer for user */
  buff = XCreatePixmap(display,win,width,height,
                       DefaultDepthOfScreen(screen_point));
  XSetForeground(display, the_GC, WhitePixel(display,screen_num));
  XFillRectangle(display, buff, the_GC, 0, 0,
                 size_hints.width, size_hints.height);
  XSetForeground(display, the_GC, BlackPixel(display,screen_num));

/* load return values */
  *p_display = display;
  *p_context = the_GC;
  return(buff);
}

/* This routine handles XEvents */
XButtonEvent *get_mouse_event()
  {
  XButtonEvent *xb_event=NULL;   /*set up event pointer for mouse events */

/* check for XEvents to be handled or returned to caller */
  while(XEventsQueued(display,QueuedAfterFlush) != 0) {
    XNextEvent(display,&event);
  /*handle button pressed or released events */
    if(event.type == ButtonPress || event.type == ButtonRelease) {
      xb_event = (XButtonEvent *) (&event);
#ifdef DEBUG1
      printf("Mouse button %d at x=%d,y=%d event type %d\n",
             xb_event->button, xb_event->x, xb_event->y,
             xb_event->type);
#endif
    }
    else if (event.type == Expose)
      update_graphics();
  }
  return(xb_event);
}

XButtonEvent *get_mouse_press(flush_true)
     Int flush_true;
{
  XButtonEvent *xb_event=NULL;   /*set up event pointer for mouse events */
  
  /*event.type= NULL;*/
  
  /* check for XEvents to be handled or returned to caller */
  if (flush_true== 1){
    while(XEventsQueued(display,QueuedAfterFlush) != 0) {
      XNextEvent(display,&event);
    }
  }
  while(event.type!= ButtonPress){
    /*while(XEventsQueued(display,QueuedAfterFlush) != 0) {*/
    XNextEvent(display,&event);
    /*handle button pressed or released events */
    if(event.type == ButtonPress) {
      xb_event = (XButtonEvent *) (&event);
#ifdef DEBUG1
      printf("Mouse button %d at x=%d,y=%d event type %d\n",
	     xb_event->button, xb_event->x, xb_event->y,
	     xb_event->type);
#endif
    }
    else if (event.type == Expose)
      update_graphics();
    /*}*/
  }
  return(xb_event);
  
  
}

XButtonEvent *get_mouse_release(flush_true)
     Int flush_true;
  {
  XButtonEvent *xb_event=NULL;   /*set up event pointer for mouse events */

/* check for XEvents to be handled or returned to caller */
  /*if (flush_true== 1)
    XFlush(display);*/
  while(XEventsQueued(display,QueuedAfterFlush) != 0) {
    XNextEvent(display,&event);
  /*handle button pressed or released events */
    if(event.type == ButtonRelease) {
      xb_event = (XButtonEvent *) (&event);
#ifdef DEBUG1
      printf("Mouse button %d at x=%d,y=%d event type %d\n",
             xb_event->button, xb_event->x, xb_event->y,
             xb_event->type);
#endif
    }
    else if (event.type == Expose)
      update_graphics();
  }
  return(xb_event);
}


XKeyEvent *get_key_event()
{
  XKeyEvent *xb_event=NULL;
  while(XEventsQueued(display,QueuedAfterFlush) != 0) {
    XNextEvent(display,&event);
    if(event.type == KeyPress || event.type == KeyRelease) {
      xb_event = (XKeyEvent *) (&event);
/*#ifdef DEBUG1
      printf("Mouse button %d at x=%d,y=%d event type %d\n",
             xb_event->button, xb_event->x, xb_event->y,
             xb_event->type);
#endif*/
    }
    else if (event.type == Expose)
      update_graphics();
  }
  return(xb_event);
}

Int update_graphics(void)
{
  XCopyArea(display,buff,win,the_GC,0,0,
          size_hints.width,size_hints.height,0,0);
}


Pixmap start_graphics();        /* declare type of start_graphics */
Pixmap my_drawing;		/* buffer to draw into */
Display *my_display;            /* pointer to X display variable */
GC my_context;                  /* X graphics context */
XImage *my_image;
Int window_width, window_height;
				/* service.c includes
				 * update_graphics()
				 * and start_graphics()*/

Int outscreen= 0;
FILE *outfile;

Int open_screen(Int width, Int height)
{
    outscreen= 1;
    window_width= width;
    window_height= height;
    my_drawing= start_graphics(width, height, &my_display, &my_context);
    clear_screen();
    flush_graphics();
}

Int open_file(char *name)
{
    outfile= fopen(name, "w");
    if (outfile) {
	fprintf(outfile,"%%!PS-Adobe-1.0\n");
	fprintf(outfile,"/LI {newpath moveto lineto stroke} bind def\n");
	fprintf(outfile,"72 72 translate\n");
	fprintf(outfile,"2 2 scale\n");
	fprintf(outfile,"1 setlinecap\n");
	fprintf(outfile,".3 setlinewidth\n");
    }
}

Int close_file(void)
{
    if (outfile) {
	fprintf(outfile, "showpage\n");
	fclose(outfile);
    }
    outfile= 0;
}

Int clear_screen(void)
{
    if (outscreen) {
	XSetForeground(my_display,my_context,BlackPixel(my_display,0));
	XFillRectangle(my_display, my_drawing, my_context,0, 0,
		       window_width, window_height);
	XSetForeground(my_display,my_context,WhitePixel(my_display,0));
    }
}

Int draw_line(Int x_start, Int y_start, Int x_end, Int y_end)
{
    if (outscreen) {
	XDrawLine(my_display, my_drawing, my_context,
		  x_start, y_start, x_end, y_end);
    }
    if (outfile) {
	fprintf(outfile,"%d %d %d %d LI\n", x_start, y_start, x_end, y_end);
    }
}

Int draw_point(Int x, Int y)
{
    if (outscreen) {
	XDrawPoint(my_display, my_drawing, my_context, x, y);
    }
    if (outfile) {
	fprintf(outfile,"%d %d %d %d LI\n", x, y, x, y);
    }
}

Int draw_line_float(double x_start, double y_start, double x_end, double y_end)
{
    if (outscreen) {
	XDrawLine(my_display, my_drawing, my_context,
		  (Int) x_start, (Int) y_start, (Int) x_end, (Int) y_end);
    }
    if (outfile) {
	fprintf(outfile,"%lf %lf %lf %lf LI\n", x_start, y_start, x_end, y_end);
    }
}

Int draw_point_float(double x, double y)
{
    if (outscreen) {
	XDrawPoint(my_display, my_drawing, my_context, (Int) x, (Int) y);
    }
    if (outfile) {
	fprintf(outfile,"%lf %lf %lf %lf LI\n", x, y, x, y);
    }
}

Int flush_graphics(void)
{
    if (outscreen) {
	update_graphics();
	XSync(my_display, 0);
    }
}

