/* qcam-Linux.c -- Linux-specific routines for accessing QuickCam */

/* Version 0.1, January 2, 1996 */


/******************************************************************

Copyright (C) 1996 by Scott Laird

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL SCOTT LAIRD BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/


#include <stdio.h>
#include <unistd.h>
#include <asm/io.h>

#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "qcam.h"
#include "qcam-Linux.h"

inline int read_lpstatus(struct qcam *q) { return inb(q->port+1); }
inline int read_lpcontrol(struct qcam *q) { return inb(q->port+2); }
inline int read_lpdata(struct qcam *q) { return inb(q->port); }
inline void write_lpdata(struct qcam *q, int d) { outb(d,q->port); }
inline void write_lpcontrol(struct qcam *q, int d) { outb(d,q->port+2); }

int enable_ports(struct qcam *q) 
{
  if(q->port<0x278) return 1; /* Better safe than sorry */
  if(q->port>0x3bc) return 1; 
  return (ioperm(q->port, 3, 1));
}

int disable_ports(struct qcam *q)
{
  return (ioperm(q->port, 3, 0));
}

/* Lock port.  This is currently sub-optimal, and is begging to be
   fixed.  It should check for dead locks.  Any takers? */

int qc_lock(struct qcam *q)
{
#if 0
  char lockfile[128], tmp[128];
  struct stat statbuf;

  sprintf(lockfile,"/tmp/LOCK.qcam.0x%x",q->port);
  sprintf(tmp,"%s-%d",lockfile,getpid());

  if ((creat(tmp,0)==-1) || 
      (link(tmp,lockfile)==-1) ||
      (stat(tmp,&statbuf)==-1) || 
      (statbuf.st_nlink==1))
  {
#ifdef DEBUGQC
    perror("QuickCam Locked");
    if(unlink(tmp)==-1)
      perror("Error unlinking temp file.");
#else
    unlink(tmp);
#endif
    return 1;
  }
  
  unlink(tmp);
  if (chown(lockfile,getuid(),getgid())==-1)
    perror("Chown problems");
#endif

  return 0;
}


/* Unlock port */

int qc_unlock(struct qcam *q)
{
#if 0
  char lockfile[128];

  sprintf(lockfile,"/tmp/LOCK.qcam.0x%x",q->port);
  unlink(lockfile); /* What would I do with an error? */
#endif

  return 0;
}


/* Probe for camera.  Returns 0 if found, 1 if not found, sets
   q->port.*/
#if 0
int qc_probe(struct qcam *q)
{
  int ioports[]={0x378, 0x278, 0x3bc,0};
  int i=0;

  /* Attempt to get permission to access IO ports.  Must be root */

  while(ioports[i]!=0) {
    q->port=ioports[i++];

    if (qc_open(q)) {
      perror("Can't get I/O permission");
      exit(1);
    }

    if(qc_detect(q)) {
      fprintf(stderr,"QuickCam detected at 0x%x\n",q->port);
      qc_close(q);
      return(0);
    }
    else
    qc_close(q);
  }

  return 1;
}
#endif


int qc_probe(struct qcam *q)
{
  int ioports[]={0x378, 0};
  int i=0;

  /* Attempt to get permission to access IO ports.  Must be root */

  while(ioports[i]!=0) {
    q->port=ioports[i++];

    if (qc_open(q)) {
      perror("Can't get I/O permission");
      exit(1);
    }

    if(qc_detect(q)) {
      fprintf(stderr,"QuickCam detected at 0x%x\n",q->port);
      qc_close(q);
      return(0);
    }
    else
    qc_close(q);
  }

  return 1;
}

/* THIS IS UGLY.  I need a short delay loop -- somthing well under a
millisecond.  Unfortunately, adding 2 usleep(1)'s to qc_command slowed
it down by a factor of over 1000 over the same loop with 2
usleep(0)'s, and that's too slow -- qc_start was taking over a second
to run.  This seems to help, but if anyone has a good
speed-independent pause routine, please tell me. -- Scott */

void qc_wait(int val)
{
  int i;
  
  while(val--)
    for(i=0;i<50000;i++);
}
