/* qcam.h -- routines for accessing the Connectix QuickCam */

/* Version 0.1, January 2, 1996 */


/******************************************************************

Copyright (C) 1996 by Scott Laird

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL SCOTT LAIRD BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#define QC_UNIDIR 1
#define QC_BIDIR  2
#define QC_SERIAL 3

struct qcam {
  int width, height;
  int bpp;
  int mode;
  int contrast, brightness, whitebal;
  int port;
  int port_mode;
};

typedef unsigned char scanbuf;

/* General QuickCam handling routines */

int qc_getbrightness(struct qcam *q);
int qc_setbrightness(struct qcam *q, int val);
int qc_getcontrast(struct qcam *q);
int qc_setcontrast(struct qcam *q, int val);
int qc_getwhitebal(struct qcam *q);
int qc_setwhitebal(struct qcam *q, int val);
void qc_getresolution(struct qcam *q, int *x, int *y);
int qc_setresolution(struct qcam *q, int x, int y);
int qc_getbitdepth(struct qcam *q);
int qc_setbitdepth(struct qcam *q, int val);
int qc_getheight(struct qcam *q);
int qc_setheight(struct qcam *q, int y);
int qc_getwidth(struct qcam *q);
int qc_setwidth(struct qcam *q, int x);

struct qcam *qc_init(void);
int qc_open(struct qcam *q);
int qc_close(struct qcam *q);
int qc_detect(struct qcam *q);
void qc_reset(struct qcam *q);
void qc_set(struct qcam *q);
scanbuf *qc_scan(struct qcam *q);
scanbuf *qc_convertscan(struct qcam *q, scanbuf *scan);
void qc_writepgm(struct qcam *q, FILE *f,scanbuf *scan);
void qc_wait(int val);

/* OS/hardware specific routines */

int read_lpstatus(struct qcam *q);
int read_lpcontrol(struct qcam *q);
int read_lpdata(struct qcam *q);
void write_lpdata(struct qcam *q, int d);
void write_lpcontrol(struct qcam *q, int d);
int enable_ports(struct qcam *q);
int disable_ports(struct qcam *q);
int qc_unlock(struct qcam *q);
int qc_lock(struct qcam *q);
void qc_wait(int val);
int qc_probe(struct qcam *q);



