/* read.c -- read bytes from a input device.
 * 
 * Copyright (c) 1995 Cygnus Support
 *
 * The authors hereby grant permission to use, copy, modify, distribute,
 * and license this software and its documentation for any purpose, provided
 * that existing copyright notices are retained in all copies and that this
 * notice is included verbatim in any distributions. No written agreement,
 * license, or royalty fee is required for any of the authorized uses.
 * Modifications to this software may be copyrighted by their authors
 * and need not follow the licensing terms described here, provided that
 * the new terms are clearly indicated on the first page of each file where
 * they apply.
 */
#include "glue.h"
#include <filedes33x.h>
#include <errno.h>

extern char _DEFUN_VOID (inbyte);

/*
 * read  -- read bytes from the serial port. Ignore fd, since
 *          we only have stdin.
 */
int
_DEFUN (read, (fd, buf, nbytes),
       int fd _AND
       char *buf _AND
       int nbytes)
{
	int i = 0;

	for (i = 0; i < nbytes; i++) {
		switch( fd )
		{
#ifdef IOOPT_QSMASYNC
			case QSMASYNC:	*(buf + i) = qsmAsyncIn();	break;
#endif
#ifdef IOOPT_QSMSYNC1
			case QSMSYNC1:	*(buf + i) = qsmSync1In();	break;
#endif
#ifdef IOOPT_QSMSYNC2
			case QSMSYNC2:	*(buf + i) = qsmSync2In();	break;
#endif
#ifdef IOOPT_QSMSYNC3
			case QSMSYNC3:	*(buf + i) = qsmSync3In();	break;
#endif
#ifdef IOOPT_QSMSYNC4
			case QSMSYNC4:	*(buf + i) = qsmSync4In();	break;
#endif
#ifdef IOOPT_KEYB
			case KEYB:		*(buf + i) = keybIn();		break;
#endif
#ifdef IOOPT_DUART1
			case DUART1:	*(buf + i) = duart1In();	break;
#endif
#ifdef IOOPT_DUART2
			case DUART2:	*(buf + i) = duart2In();	break;
#endif
#ifdef IOOPT_CENT
			case CENT:		*(buf + i) = centIn();		break;
#endif
			default:	errno=EIO;	return(-1);		break;
		}
		
		if ((*(buf + i) == '\n') || (*(buf + i) == '\r'))
		{
			(*(buf + i + 1)) = 0;
			break;
		}
	}
	return (i);
}
