|****************************************************************************
|*																			*
|*	cogito Gesellschaft fuer Elektronikentwicklung mbH						*
|*		info@cogito.de		http://www.cogito.de/							*
|*	  																		*
|*		beep for mc68xxx single-board-computer								*
|*																			*
|*				File			: beep.s									*
|*				Author			: Frank Sautter								*
|*				First Byte		: 14.07.93									*
|*				Latest Change	: 12.06.96									*
|*																			*
|****************************************************************************

			.include		"mc683xx.inc"

|****************************************************************************
|*	beep																	*
|*	in:			d0 frequency												*
|*				d1 duration in ms											*
|*	out:		d0 duration in ms											*
|*	violated:	d0,d2,d2													*
|****************************************************************************

beep:
			ext.l		d1
			divu		#10,d1
			ext.l		d1
			add.l		sysclock,d1

			tst.l		d0
			beq			.branch2
			move.l		cpuspeed,d2
			mulu		#10,d0
			divu		d0,d2
			bvs			.branch2
			ext.l		d2
			subq.l		#4,d2
			tst.l		d2
			bpl			.branch1
			moveq.l		#0,d2

.if MC68331 
.branch1:	or.b        #0x03,gpt_pddr
			bset.b		#0,gpt_pdr
			bclr.b		#1,gpt_pdr

.loop1:		eor.b		#0x03,gpt_pdr
			move.w		d2,d0
.loop2:		dbra		d0,.loop2
			cmp.l		sysclock,d1
			bpl			.loop1
.endif

.if MC68332
.branch1:	move.w		tpu_cfsr3,d0
			and.w		#0xf00f,d0
			and.w		#0x0880,d0
			move.w		d0,tpu_cfsr3
			or.w		#0x003c,tpu_cpr1
			
.loop1:		bset.b		#2,tpu_hsrr1+1
			bset.b		#5,tpu_hsrr1+1		
			move.w		d2,d0
.loop2:		dbra		d0,.loop2
			nop
			nop
			nop
			bset.b		#3,tpu_hsrr1+1
			bset.b		#4,tpu_hsrr1+1		
			move.w		d2,d0
.loop3:		dbra		d0,.loop3
			cmp.l		sysclock,d1
			bpl			.loop1
			rts
.endif
			
.branch2:	cmp.l		sysclock,d1
			bpl			.branch2
			rts


|****************************************************************************
