|****************************************************************************
|*																			*
|*	cogito Gesellschaft fuer Elektronikentwicklung mbH						*
|*		info@cogito.de		http://www.cogito.de/							*
|*	  																		*
|*		embedded flash programming for mc68xxx single-board-computer		*
|*																			*
|*				File			: embd.flash.s								*
|*				Author			: Frank Sautter								*
|*				First Byte		: 11.11.94									*
|*				Latest Change	: 17.06.96									*
|*																			*
|****************************************************************************

				.include	"mc683xx.inc"
				.include	"embd.flash.inc"

|****************************************************************************
|*	autoselect																*
|*	in:			d0 = 0 manufacterer id ; = 1 device code					*
|*	out:		d0 = code													*
|*	violated:	a0,d1														*
|****************************************************************************

				.globl		embd_autosel
embd_autosel:	move.b		#0xaa,flashbase+0x5555
				move.b		#0x55,flashbase+0x2aaa
				move.b		#0x90,flashbase+0x5555
				and.l		#1,d0
				lea			flashbase,a0
				move.b		0(a0,d0.w),d0
				move.b		#0xaa,flashbase+0x5555
				move.b		#0x55,flashbase+0x2aaa
				move.b		#0xf0,flashbase+0x5555
				rts


|****************************************************************************
|*	check sector protection													*
|*	in:			d0 sector number to be checked								*
|*	out:		d0 = code													*
|*	violated:	a0,d1														*
|****************************************************************************

				.globl		embd_chksector
embd_chksector:	move.b		#0xaa,flashbase+0x5555
				move.b		#0x55,flashbase+0x2aaa
				move.b		#0x90,flashbase+0x5555
				and.l		#7,d0
				lsl.l		#8,d0
				lsl.l		#6,d0
				lea			flashbase,a0
				move.b		2(a0,d0.l),d0
				and.l		#0xff,d0
				move.b		#0xaa,flashbase+0x5555
				move.b		#0x55,flashbase+0x2aaa
				move.b		#0xf0,flashbase+0x5555
				rts


|****************************************************************************
|*	chip erase																*
|*	in:			void														*
|*	out:		d0 != 0 error												*
|*	violated:	void														*
|****************************************************************************

				.globl		embd_chiperase
embd_chiperase:	move.b		#0xaa,flashbase+0x5555
				move.b		#0x55,flashbase+0x2aaa
				move.b		#0x80,flashbase+0x5555
				move.b		#0xaa,flashbase+0x5555
				move.b		#0x55,flashbase+0x2aaa
				move.b		#0x10,flashbase+0x5555

ce_01:			move.b		flashbase,d0
				cmp.b		#0xff,d0
				beq			ce_02
				btst		#5,d0
				beq			ce_01				

				move.b		#0xaa,flashbase+0x5555
				move.b		#0x55,flashbase+0x2aaa
				move.b		#0xf0,flashbase+0x5555
				moveq.l		#-1,d0
				rts
				
ce_02:			move.b		#0xaa,flashbase+0x5555
				move.b		#0x55,flashbase+0x2aaa
				move.b		#0xf0,flashbase+0x5555
				moveq.l		#0,d0
				rts


|****************************************************************************
|*	sector erase															*
|*	in:			d0 bit														*
|*	out:		d0 != 0 error												*
|*	violated:																*
|****************************************************************************

				.globl		embd_secterase
embd_secterase:	move.b		#0xaa,flashbase+0x5555
				move.b		#0x55,flashbase+0x2aaa
				move.b		#0x80,flashbase+0x5555
				move.b		#0xaa,flashbase+0x5555
				move.b		#0x55,flashbase+0x2aaa

				btst		#0,d0
				beq			se_01
				lea			flashbase+0x00000,a0
				move.b		#0x30,(a0)
se_01:			btst		#1,d0
				beq			se_02
				lea			flashbase+0x04000,a0
				move.b		#0x30,(a0)
se_02:			btst		#2,d0
				beq			se_03
				lea			flashbase+0x08000,a0
				move.b		#0x30,(a0)
se_03:			btst		#3,d0
				beq			se_04
				lea			flashbase+0x0c000,a0
				move.b		#0x30,(a0)
se_04:			btst		#4,d0
				beq			se_05
				lea			flashbase+0x10000,a0
				move.b		#0x30,(a0)
se_05:			btst		#5,d0
				beq			se_06
				lea			flashbase+0x14000,a0
				move.b		#0x30,(a0)
se_06:			btst		#6,d0
				beq			se_07
				lea			flashbase+0x18000,a0
				move.b		#0x30,(a0)
se_07:			btst		#7,d0
				beq			se_08
				lea			flashbase+0x1c000,a0
				move.b		#0x30,(a0)

se_08:			move.b		(a0),d0
				cmp.b		#0xff,d0
				beq			se_09
				btst		#5,d0
				beq			se_08				
				
				move.b		#0xaa,flashbase+0x5555
				move.b		#0x55,flashbase+0x2aaa
				move.b		#0xf0,flashbase+0x5555
				moveq.l		#-1,d0
				rts

se_09:			move.b		#0xaa,flashbase+0x5555
				move.b		#0x55,flashbase+0x2aaa
				move.b		#0xf0,flashbase+0x5555
				moveq.l		#0,d0
				rts
				

|****************************************************************************
|*	programm byte															*
|*	in:			d0 address to be programmed									*
|*				d1 byte to be programmed									*
|*	out:		d0 != 0 error												*
|*	violated:	a0															*
|****************************************************************************

				.globl		embd_program
embd_program:	move.b		#0xaa,flashbase+0x5555
				move.b		#0x55,flashbase+0x2aaa
				move.b		#0xa0,flashbase+0x5555
				lea			flashbase,a0
				add.l		d0,a0
				move.b		d1,(a0)
				
ep_01:			cmp.b		(a0),d1
				bne			ep_01

				move.b		#0xaa,flashbase+0x5555
				move.b		#0x55,flashbase+0x2aaa
				move.b		#0xf0,flashbase+0x5555
				moveq.l		#0,d0
				rts


|****************************************************************************
|*	read byte																*
|*	in:			d0 address to be read										*
|*	out:		d0 byte read												*
|*	violated:	a0															*
|****************************************************************************

				.globl		embd_read
embd_read:		lea			flashbase,a0
				add.l		d0,a0
				moveq.l		#0,d0
				move.b		(a0),d0
				rts


|****************************************************************************
