|****************************************************************************
|*																			*
|*	cogito Gesellschaft fr Elektronikentwicklung mbH						*
|*		info@cogito.de		http://www.cogito.de/							*
|*	  																		*
|*		hardware definition file for mc683xx series							*
|*																			*
|*				File			: mc683xx.inc								*
|*				Author			: Frank Sautter								*
|*				First Byte		: 15.07.93									*
|*				Latest Change	: 14.06.96									*
|*																			*
|****************************************************************************

|****************************************************************************
|*	MC683XX Opcodes										
|****************************************************************************

bgnd			=		0x4afa

|****************************************************************************
|*	Defines												
|****************************************************************************

gptbase			=		0xfff900
simbase			=		0xfffa00
ramctrlbase		=		0xfffb00
qsmbase			=		0xfffc00
tpubase			=		0xfffe00
tpuparbase		=		0xffff00

|****************************************************************************

gpt_gmcr		=		gptbase				|* GPT Module Configuration
gpt_icr			=		gptbase+0x04		|* GPT Interrupt Configuration
gpt_pddr		=		gptbase+0x06		|* GPT Port Data Direction
gpt_pdr			=		gptbase+0x07		|* GPT Port Data Register
gpt_oc1m		=		gptbase+0x08		|* GPT Action Mask
gpt_oc1d		=		gptbase+0x09		|* GPT Action Data
gpt_tcnt		=		gptbase+0x0a		|* GPT Timer Counter
gpt_pactl		=		gptbase+0x0c		|* GPT Pulse Accumulator Control
gpt_pacnt		=		gptbase+0x0d		|* GPT Pulse Accumulator Counter
gpt_tic1		=		gptbase+0x0e		|* GPT Input Capture 1
gpt_tic2		=		gptbase+0x10		|* GPT Input Capture 2
gpt_tic3		=		gptbase+0x12		|* GPT Input Capture 3
gpt_toc1		=		gptbase+0x14		|* GPT Output Capture 1
gpt_toc2		=		gptbase+0x16		|* GPT Output Capture 2
gpt_toc3		=		gptbase+0x18		|* GPT Output Capture 3
gpt_toc4		=		gptbase+0x1a		|* GPT Output Capture 4
gpt_ti4o5		=		gptbase+0x1c		|* GPT Input 4 Output 5 Capture
gpt_tctl1		=		gptbase+0x1e		|* GPT Timer Control 1
gpt_tctl2		=		gptbase+0x1f		|* GPT Timer Control 2
gpt_tmsk1		=		gptbase+0x20		|* GPT Timer Interrupt Mask 1
gpt_tmsk2		=		gptbase+0x21		|* GPT Timer Interrupt Mask 2
gpt_tflg1		=		gptbase+0x22		|* GPT Timer Interrupt Flag 1
gpt_tflg2		=		gptbase+0x23		|* GPT Timer Interrupt Flag 2
gpt_cforc		=		gptbase+0x24		|* GPT Compare Force
gpt_pwmc		=		gptbase+0x25		|* GPT PWM Control
gpt_pwma		=		gptbase+0x26		|* GPT PWMA Register
gpt_pwmb		=		gptbase+0x27		|* GPT PWMB Register
gpt_pwmcnt		=		gptbase+0x28		|* GPT PWM Count
gpt_pwmabuf		=		gptbase+0x2a		|* GPT PWMA Buffer
gpt_pwmbbuf		=		gptbase+0x2b		|* GPT PWMB Buffer
gpt_prescl		=		gptbase+0x2c		|* GPT Prescaler

|****************************************************************************

sim_mcr			=		simbase				|* Module Configuration
sim_simtr		=		simbase+0x02		|* Module Test	
sim_syncr		=		simbase+0x04		|* Clock Synthesizer Control
sim_rsr			=		simbase+0x07		|* Reset Status Register
sim_simtre		=		simbase+0x08		|* Module Test E
sim_porte		=		simbase+0x13		|* Port E Data	
sim_ddre		=		simbase+0x15		|* Port E Data Direction
sim_pepar		=		simbase+0x17		|* Port E Pin Assignment
sim_portf		=		simbase+0x1b		|* Port F Data	
sim_ddrf		=		simbase+0x1d		|* Port F Data Direction
sim_pfpar		=		simbase+0x1f		|* Port F Pin Assignment
sim_sypcr		=		simbase+0x21		|* System Protection Control
sim_picr		=		simbase+0x22		|* Periodic Interrupt Control
sim_pitr		=		simbase+0x24		|* Periodic Interrupt Timing
sim_swsr		=		simbase+0x27		|* Software Service
sim_tstmsra		=		simbase+0x30		|* Test Module Master Shift A
sim_tstmsrb		=		simbase+0x32		|* Test Module Master Shift B
sim_tstsca		=		simbase+0x34		|* Test Module Shift Count A
sim_tstscb		=		simbase+0x35		|* Test Module Shift Count B
sim_tstrc		=		simbase+0x36		|* Test Module Repetition Count
sim_creg		=		simbase+0x38		|* Test Module Control Register
sim_dreg		=		simbase+0x3a		|* Test Module Distributed Register
sim_cspdr		=		simbase+0x41		|* Port C Data	
sim_cspar0		=		simbase+0x44		|* Chip Select Pin Assignment 0
sim_cspar1		=		simbase+0x46		|* Chip Select Pin Assignment 1
sim_csbarbt		=		simbase+0x48		|* Chip Select Base Boot
sim_csorbt		=		simbase+0x4a		|* Chip Select Option Boot
sim_csbar0		=		simbase+0x4c		|* Chip Select Base 0
sim_csor0		=		simbase+0x4e		|* Chip Select Option 0
sim_csbar1		=		simbase+0x50		|* Chip Select Base 1
sim_csor1		=		simbase+0x52		|* Chip Select Option 1
sim_csbar2		=		simbase+0x54		|* Chip Select Base 2
sim_csor2		=		simbase+0x56		|* Chip Select Option 2
sim_csbar3		=		simbase+0x58		|* Chip Select Base 3
sim_csor3		=		simbase+0x5a		|* Chip Select Option 3
sim_csbar4		=		simbase+0x5c		|* Chip Select Base 4
sim_csor4		=		simbase+0x5e		|* Chip Select Option 4
sim_csbar5		=		simbase+0x60		|* Chip Select Base 5
sim_csor5		=		simbase+0x62		|* Chip Select Option 5
sim_csbar6		=		simbase+0x64		|* Chip Select Base 6
sim_csor6		=		simbase+0x66		|* Chip Select Option 6
sim_csbar7		=		simbase+0x68		|* Chip Select Base 7
sim_csor7		=		simbase+0x6a		|* Chip Select Option 7
sim_csbar8		=		simbase+0x6c		|* Chip Select Base 8
sim_csor8		=		simbase+0x6e		|* Chip Select Option 8
sim_csbar9		=		simbase+0x70		|* Chip Select Base 9
sim_csor9		=		simbase+0x72		|* Chip Select Option 9
sim_csbar10		=		simbase+0x74		|* Chip Select Base 10
sim_csor10		=		simbase+0x76		|* Chip Select Option 10

|****************************************************************************

ram_mcr			=		ramctrlbase			|* RAM Configuration
ram_tst			=		ramctrlbase+0x02	|* RAM Test		
ram_bar			=		ramctrlbase+0x04	|* RAM Base Address/Status

|****************************************************************************

qsm_qmcr		=		qsmbase				|* QSM Module Configuration
qsm_qtest		=		qsmbase+0x02		|* QSM Test		
qsm_qilr		=		qsmbase+0x04		|* QSM Interrupt Level
qsm_qivr		=		qsmbase+0x05		|* QSM Interrupt Vector
qsm_sccr0		=		qsmbase+0x08		|* SCI Control 0
qsm_sccr1		=		qsmbase+0x0a		|* SCI Control 1
qsm_scsr		=		qsmbase+0x0c		|* SCI Status	
qsm_scdr		=		qsmbase+0x0e		|* SCI Data		
qsm_qpdr		=		qsmbase+0x15		|* QSM Port Data
qsm_qpar		=		qsmbase+0x16		|* QSM Pin Assignment
qsm_qddr		=		qsmbase+0x17		|* QSM Data Direction
qsm_spcr0		=		qsmbase+0x18		|* QSPI Control 0
qsm_spcr1		=		qsmbase+0x1a		|* QSPI Control 1
qsm_spcr2		=		qsmbase+0x1c		|* QSPI Control 2
qsm_spcr3		=		qsmbase+0x1e		|* QSPI Control 3
qsm_spsr		=		qsmbase+0x1f		|* QSPI Status	

qsm_rec			=		qsmbase+0x100		|* QSPI Receive RAM
qsm_tran		=		qsmbase+0x120		|* QSPI Transfer RAM
qsm_comd		=		qsmbase+0x140		|* QSPI Command RAM

|****************************************************************************

tpu_mcr			=		tpubase				|* TPU Module Configuration
tpu_cr			=		tpubase+0x02		|* TPU Configuration
tpu_dscr		=		tpubase+0x04		|* TPU Developement Support Control
tpu_dssr		=		tpubase+0x06		|* TPU Developement Support Status
tpu_icr			=		tpubase+0x08		|* TPU Interrupt Configuration
tpu_ier			=		tpubase+0x0a		|* TPU Interrupt Enable
tpu_cfsr0		=		tpubase+0x0c		|* TPU Channel Function	Select 0
tpu_cfsr1		=		tpubase+0x0e		|* TPU Channel Function	Select 1
tpu_cfsr2		=		tpubase+0x10		|* TPU Channel Function	Select 2
tpu_cfsr3		=		tpubase+0x12		|* TPU Channel Function	Select 3
tpu_hsr0		=		tpubase+0x14		|* TPU Host S=ence 0
tpu_hsr1		=		tpubase+0x16		|* TPU Host S=ence 1
tpu_hsrr0		=		tpubase+0x18		|* TPU Host Service R=est 0
tpu_hsrr1		=		tpubase+0x1a		|* TPU Host Service R=est 1
tpu_cpr0		=		tpubase+0x1c		|* TPU Channel Priority 0
tpu_cpr1		=		tpubase+0x1e		|* TPU Channel Priority 1
tpu_isr			=		tpubase+0x20		|* TPU Interrupt Status
tpu_lr			=		tpubase+0x22		|* TPU Link		
tpu_sglr		=		tpubase+0x24		|* TPU Service Grant Latch
tpu_dcnr		=		tpubase+0x26		|* TPU Decoded Channel Number

|****************************************************************************
