/* STARTUP(crt0.o) */
OUTPUT_ARCH(m68k)
SEARCH_DIR(.)
INPUT(robot.o)

/*
 * Setup the memory map of the M68332BCC Business Card Computer.
 * stack grows down from high memory.
 *
 * The memory map look like this:
 * +--------------------+ <- low memory
 * | .text              |
 * |        _etext      |
 * |        ctor list   | the ctor and dtor lists are for
 * |        dtor list   | C++ support
 * +--------------------+
 * | .data              | initialized data goes here
 * |        _edata      |
 * +--------------------+
 * | .bss               |
 * |        __bss_start | start of bss, cleared by crt0
 * |        _end        | start of heap, used by sbrk()
 * +--------------------+
 * .                    .
 * .                    .
 * .                    .
 * |        __stack     | top of stack
 * +--------------------+
 */
MEMORY
{
  ram     : ORIGIN = 0x000000,  LENGTH = 1M
}

/*
 * stick everything in ram (of course)
 */
SECTIONS
{
  .text :
  {
    *(.text)
    _etext = .;
    __CTOR_LIST__ = .;
    LONG((__CTOR_END__ - __CTOR_LIST__) / 4 - 2)
    *(.ctors)
    LONG(0)
    __CTOR_END__ = .;
    __DTOR_LIST__ = .;
    LONG((__DTOR_END__ - __DTOR_LIST__) / 4 - 2)
    *(.dtors)
    LONG(0)
    __DTOR_END__ = .;
    *(.lit)
    *(.shdata)
  } > ram

  .shbss SIZEOF(.text) + ADDR(.text) :
  {
    *(.shbss)
  } > ram

  .data :
  {
    *(.data)
    _edata = .;
  } > ram

  .bss :
  {
    __bss_start = ALIGN(0x8);
    *(.bss)
    *(COMMON)
    _end = ALIGN(0x8);
    __end = ALIGN(0x8);
  } > ram

  .stab . (NOLOAD) :
  {
    [ .stab ]
  }

  .stabstr . (NOLOAD) :
  {
    [ .stabstr ]
  }
}

/* __stack = 64K - 8; */


