/* write.c -- write bytes to an output device.
 *
 * Copyright (c) 1995 Cygnus Support
 *
 * The authors hereby grant permission to use, copy, modify, distribute,
 * and license this software and its documentation for any purpose, provided
 * that existing copyright notices are retained in all copies and that this
 * notice is included verbatim in any distributions. No written agreement,
 * license, or royalty fee is required for any of the authorized uses.
 * Modifications to this software may be copyrighted by their authors
 * and need not follow the licensing terms described here, provided that
 * the new terms are clearly indicated on the first page of each file where
 * they apply.
 */
#include "glue.h"
#include <filedes33x.h>
#include <errno.h>

extern int  _EXFUN (outbyte, (char x));

/*
 * write -- write bytes to the serial port. Ignore fd, since
 *          stdout and stderr are the same. Since we have no filesystem,
 *          open will only return an error.
 */
int
_DEFUN (write, (fd, buf, nbytes),
       int fd _AND
       char *buf _AND
       int nbytes)
{
	int i;

	for (i = 0; i < nbytes; i++) {
/*		if (*(buf + i) == '\n') 
		{
			outbyte ('\r');
		} */
		
		switch( fd )
		{
#ifdef IOOPT_QSMASYNC
			case QSMASYNC:	qsmAsyncOut(*(buf + i));	break;
#endif
#ifdef IOOPT_QSMSYNC1
			case QSMSYNC1:	qsmSync1Out(*(buf + i));	break;
#endif
#ifdef IOOPT_QSMSYNC2
			case QSMSYNC2:	qsmSync2Out(*(buf + i));	break;
#endif
#ifdef IOOPT_QSMSYNC3
			case QSMSYNC3:	qsmSync3Out(*(buf + i));	break;
#endif
#ifdef IOOPT_QSMSYNC4
			case QSMSYNC4:	qsmSync4Out(*(buf + i));	break;
#endif
#ifdef IOOPT_LCDALNUM
			case LCDALNUM:	lcdAlnumOut(*(buf + i));	break;
#endif
#ifdef IOOPT_LCDGRAPH
			case LCDGRAPH:	lcdGraphOut(*(buf + i));	break;
#endif
#ifdef IOOPT_DUART1
			case DUART1:	duart1Out(*(buf + i));		break;
#endif
#ifdef IOOPT_DUART2
			case DUART2:	duart2Out(*(buf + i));		break;
#endif
#ifdef IOOPT_CENT
			case CENT:		centOut(*(buf + i));		break;
#endif
			default:		errno=EIO;	return(-1);		break;
		}
	}
	return (nbytes);
}
