|****************************************************************************
|*																			*
|*	cogito Gesellschaft fuer Elektronikentwicklung mbH						*
|*		info@cogito.de		http://www.cogito.de/							*
|*	  																		*
|*		target-resident command drivers for 29F0X0 flash programming		*
|*		for mc68xxx single-board-computer									*
|*																			*
|*				File			: trflash.s									*
|*				Author			: Frank Sautter								*
|*				First Byte		: 17.06.96									*
|*				Latest Change	: 18.06.96									*
|*																			*
|****************************************************************************

				.include	"ipd.inc"
				.include	"embd.flash.inc"
				.text

|****************************************************************************

				.long		main						| Pointer to start address

greetmsg:		.asciz		"target resident driver for flash-rom programming\n"

no_params1:		.asciz		"Usage: flash <erase_sectors> <filename> <d_offset>\n"
no_params2:		.asciz		" <erase_sectors>:  bit vector of sectors within the flash to be erased\n"
no_params3:		.asciz		" <filename>:       filename of s-record to be programmed\n"
no_params4:		.asciz		" <offset>:         offset from base address of flash-rom\n"

deviceman:		.asciz		" manufacturer: AMD\n"
devicetype:		.asciz		" devicetype:   29F010\n"
progess:		.asciz		"."

fmode:			.asciz		"r"

				.balign		2

|****************************************************************************

main:			move.l		a0,a6						| get argv in a6
				move.l		d0,d7						| get argc
in d7

				lea.l		stack(pc),ssp  				| set supervisor stack
				
				lea.l		greetmsg(pc),a0   			| print greeting message
				moveq.l		#BD_PUTS,d0					| use 'putstring' function in BD32
				bgnd

				moveq.l		#0,d0
				bsr			embd_autosel
				cmp.b		#0x01,d0
				beq			man_ok

				moveq.l		#3,d1						| unsupported manufacturer
				moveq.l		#BD_QUIT,d0					| leave driver
				bgnd				

man_ok:			lea.l		deviceman(pc),a0   			| print greeting message
				moveq.l		#BD_PUTS,d0					| use 'putstring' function in BD32
				bgnd
				
				moveq.l		#1,d0						| get device type
				bsr			embd_autosel
				cmp.b		#0x20,d0
				beq			dev_ok

				moveq.l		#4,d1						| unsupported device type
				moveq.l		#BD_QUIT,d0					| leave driver
				bgnd				

dev_ok:			lea.l		devicetype(pc),a0   		| print greeting message
				moveq.l		#BD_PUTS,d0					| use 'putstring' function in BD32
				bgnd
				
				cmp.l		#1,d7						| arg count = 1
				bne			testargs
				lea.l		no_params1(pc),a0   		| print usage message
				moveq.l		#BD_PUTS,d0					| use 'putstring' function in BD32
				bgnd
				lea.l		no_params2(pc),a0   		| print usage message
				moveq.l		#BD_PUTS,d0					| use 'putstring' function in BD32
				bgnd
				lea.l		no_params3(pc),a0   		| print usage message
				moveq.l		#BD_PUTS,d0					| use 'putstring' function in BD32
				bgnd
				lea.l		no_params4(pc),a0   		| print usage message
				moveq.l		#BD_PUTS,d0					| use 'putstring' function in BD32
				bgnd

				moveq.l		#0,d1
				moveq.l		#BD_QUIT,d0					| ok leave driver
				bgnd				

testargs:		cmp.l		#4,d7						| arg count = 4
				beq			argsok

				moveq.l		#1,d1						| number of parameters
				moveq.l		#BD_QUIT,d0					| leave driver
				bgnd				

argsok:			move.l		12(a6),a0					| get offset address
				moveq.l		#BD_EVAL,d0					| use 'eval' function in BD32
				bgnd

				tst.l		d0
				beq			evalok

				moveq.l		#6,d1						| error in offset address
				moveq.l		#BD_QUIT,d0					| leave driver
				bgnd				

evalok:			move.l		d1,d7

				move.l		4(a6),a1
				moveq.l		#0,d0
				moveq.l		#0,d1
tbf_01:			cmp.b		#'0',(a1,d1.w)
				beq			tbf_03
				cmp.b		#'1',(a1,d1.w)
				beq			tbf_04
				cmp.b		#0,(a1,d1.w)
				beq			tbf_05
				
tbf_02:			moveq.l		#2,d1						| error in bit vector
				moveq.l		#BD_QUIT,d0					| leave driver
				bgnd				
				
tbf_03:			addq.l		#1,d1
				bra			tbf_01

tbf_04:			bset		d1,d0						| set bit in bitfield according to input
				addq.l		#1,d1
				bra			tbf_01

tbf_05:			cmp.l		#8,d1						| check if bitfield is 8 character long
				bne			tbf_02

				bsr			embd_secterase				| erase marked sectors in flash

				move.l		8(a6),a0					| filename
				lea.l		fmode(pc),a1   				| filemode
				moveq.l		#BD_FOPEN,d0				| use 'open' function in BD32
				bgnd

				moveq.l		#-1,d3
				move.l		d0,d6						| file handle

read_s:			move.l		d6,d1						| file handle
				lea.l		srec(pc),a0   				| buffer address
				moveq.l		#BD_FREADSREC,d0			| use 'S-record' function in BD32
				bgnd

				cmp.w		#0,d0						| error while reading ?
				beq			read_ok
				cmp.w		#2,d0						| end of S-record reached ?
				beq			end_of_srec

				moveq.l		#5,d1						| error while reading S-record
				moveq.l		#BD_QUIT,d0					| leave driver
				bgnd				

read_ok:		lea.l		srec(pc),a1  				| buffer address

				move.b		0(a1),d1
				add.b		#'0',d1
				moveq.l		#BD_PUTCHAR,d0				| use 'put char' function in BD32
				bgnd				

				cmp.b		#0,0(a1)					| S0 record?
				beq			read_s

				cmp.l		#-1,d3
				bne			offsetok

				move.l		2(a1),d3
				
offsetok:		moveq.l		#0,d5
				moveq.l		#0,d4
				move.b		1(a1),d4
				subq.l		#5,d4

progloop:		move.b		6(a1,d5.w),d1
				move.l		2(a1),d0
				sub.l		d3,d0
				add.l		d5,d0
				add.l		d7,d0						| add offset

				bsr			embd_program

				addq.l		#1,d5
				dbra		d4,progloop
				bra			read_s				

end_of_srec:	move.l		d6,d1						| file handle
				moveq.l		#BD_FCLOSE,d0				| use 'close' function in BD32
				bgnd

				moveq.l		#0,d1
				moveq.l		#BD_QUIT,d0					| ok leave driver
				bgnd				


|****************************************************************************
				.bss
srec:			.space		256

				.space		256
stack:

|****************************************************************************
