#ifndef _ADDRESS_H_
#define _ADDRESS_H_

/*
 * address.h - Hardware-dependent memory mappings for a homebrew 68000 board. 
 */

/* Basic hardware configuration. */

#define RAM_BASE ((char * volatile) 0x000000)	/* Base address of static
						 * RAM. */
#define RAM_SIZE ((char * volatile) 0x080000)	/* RAM size is 512K. */

#define IO0_BASE ((char * volatile) 0x100000)	/* Base address for internal
						 * DTACK I/O. */

#define IO0_SIZE ((char * volatile) 0x100000)	/* I/O block size is 1Mb. */

#define IO1_BASE ((char * volatile) 0x200000)	/* Base address for external
						 * DTACK I/O. */

#define IO1_SIZE ((char * volatile) 0x100000)	/* I/O block size is 1Mb. */

#define ROM_BASE ((char * volatile) 0xF00000)	/* Base address for ROM. */
#define ROM_SIZE ((char * volatile) 0x020000)	/* ROM size is 128K. */

/* Define location and size of exception vector table. */
#define VEC_BASE	RAM_BASE/* Vector table is at the bottom of memory. */

/* Define supervisor stack pointer to point to the top of static RAM. */
#define SSP	(RAM_BASE + RAM_SIZE - 1)

#endif
