#
#	cswitch.s - Routines which save and replace the cpu context.
#

#
#	Reserve space to save the cpu registers.
#
REG_BYTES	= 64			| size of 'struct m68k_regs'.

	.data
	.even
reg_list:
	.skip	REG_BYTES

#
#	push_regs - Stores the cpu registers in 'reg_list'.
#

	.text
	.globl	push_regs

push_regs:
	moveml	d0-d7/a0-a7,reg_list	| Save all the registers to memory.
	movl	sp,a6			| Get the stack pointer.
	addql	#4,a6			| Add offset to point to exc frame.
	movl	a6,sp@-			| Push exception frame pointer.
	pea	reg_list		| Push address of register list.
	jsr	_get_context		| Call high-level exception handler.


#
# various offsets in 'pstat' -- update according to the definition of
# struct pstat in "reg.h"
#

A0_OFFSET	= 32
USP_OFFSET	= REG_BYTES
SSP_OFFSET	= REG_BYTES - 4
PC_OFFSET	= REG_BYTES + 4
SR_OFFSET	= REG_BYTES + 8
FLAGS_OFFSET	= REG_BYTES + 10


	.globl	_cswitch

_cswitch:
	movl	a0,sp@-			| save a0
	movl	sp@(8),a0		| a0 <- old pstat ptr
	movml	d0-d7/a0-a7,a0@		| save all regs
	movl	sp@,a0@(A0_OFFSET)	| restore a0 from saved val on stack
	addql	#8,a0@(SSP_OFFSET)	| make SP look as if after call-return
	movw	sr,a0@(SR_OFFSET)
	movl	sp@(4),a0@(PC_OFFSET)	| PC from the stack
	movl	sp@(12),a0		| a0 <- new pstat ptr
	movml	a0@,d0-d7/a0-a6		| restore all regs (excpt SP)
	movl	sp@(12),a0		| a0 <- new pstat ptr again (wipe above)
	movl	a0@(SSP_OFFSET),sp	| retrieve SP from new pstat
	movl	a0@(PC_OFFSET),sp@-	| push new PC
	movw	a0@(SR_OFFSET),sr	
	movl	a0@(A0_OFFSET),a0
	rts


#
#	restore - restores context.  Argument is a pointer to 'struct pstat'.
#

	.globl	_restore

_restore:
	addql	#4,sp			| Pop unnecessary return address.
	movl	sp@,a0			| Get pointer to 'struct pstat'.
	movl	a0@(USP_OFFSET),a1	| Get saved value of 'usp'.
	movl	a1,usp			| Restore 'usp'.
	movl	a0@(SSP_OFFSET),a1	| Get saved 'sp' value.
	movl	a0@(PC_OFFSET),a1@-	| Push new exception frame 'pc' value.
	movw	a0@(SR_OFFSET),a1@-	| Push new exception frame 'sr' value.
	movl	a0,sp			| Move stack pointer to register list.
	moveml	sp@,d0-d7/a0-a6		| Restore all registers except 'sp'.
	movl	sp@(SSP_OFFSET),sp	| Restore stack pointer.
	subql	#6,sp			| Drop down to point to new exc frame.
	rte				| Return from exception.
	
#
#	get_usp - Returns the user stack pointer.
#
	.globl	_get_usp

_get_usp:
	link	a6,#0
	movl	usp,a0			| Get the user stack pointer.
	movl	a0,d0			| Return the value.
	unlk	a6
	rts
