#ifndef _DUART_H_
#define _DUART_H_

/*
 * duart.h - Non-user definitions for DUART control. 
 */

#include "address.h"

/* Control word masks. */

#define TX_RDY		0x04	/* Transmit ready bit mask. */
#define RX_RDY		0x01	/* Receiver ready bit mask. */

/* DUART channel base addresses. */

#define DUART_A		IO1_BASE + 0	/* Address of 'A' channel register
					 * set. */
#define DUART_B		IO1_BASE + 16	/* Address of 'B' channel register
					 * set. */

/* Control register offsets (relative to IO1_BASE). */

#define IPCR		9	/* Address of input port change register. */
#define ACR		9	/* Address of auxiliary control register. */

#define ISR		11	/* Address of interrupt status register. */
#define IMR		11	/* Address of interrupt mask register. */

#define CUR		13	/* Counter MSB. */
#define CTUR		13	/* Counter/timer upper register. */

#define CLR		15	/* Counter LSB. */
#define CTLR		15	/* Counter/timer lower register. */

#define IVR		25	/* Interrupt vector register. */

#define IBUF		27	/* Input port (unlatched). */
#define OPCR		27	/* Output port configuration register. */

#define C_START		29	/* Start-counter command. */
#define C_STOP		31	/* Stop-counter command. */

#define	OPR_SET		29	/* Output port register bit-set command. */
#define OPR_RESET	31	/* Output port regsiter bit-reset command. */

/* Serial control register offsets (relative to 'DUART_A' or 'DUART_B'). */

#define MR1		1	/* Offset of mode register one. */
#define MR2		1	/* Offset of mode register two. */

#define SR		3	/* Offset of status register. */
#define CSR		3	/* Offset of clock select register. */

#define CR		5	/* Offset of command register. */

#define RB		7	/* Address of receive buffer. */
#define TB		7	/* Address of transmit buffer. */

/* Baud rate control values. */

#define BAUD50		0x00
#define BAUD110		0x11
#define BAUD135		0x22
#define BAUD200		0x33
#define BAUD300		0x44
#define BAUD600		0x55
#define BAUD1200	0x66
#define BAUD1050	0x77
#define BAUD2400	0x88
#define BAUD4800	0x99
#define BAUD7200	0xaa
#define BAUD9600	0xbb
#define BAUD38400	0xcc

/* DUART crystal frequency and timer frequency. */

#define DUART_FREQ	230400	/* 3.6864 Mhz divided by 16 prescaler. */
#define TIMER_FREQ	60	/* Frequency of real-time clock ticks. */

/* Hard-wired control words. */

#define	ACR_DEFAULT	0x70	/* Selects BRG set zero, timer source XTAL /
				 * 16. */
#define MR1_DEFAULT	0x02	/* Selects 7-bit data, even parity. */
#define MR2_DEFAULT	0x0f	/* Normal mode, 2 stop bits, CTS and RTS
				 * control off. */
#define CR_DEFAULT	0x05	/* Enables serial channel. */
#define IMR_DEFAULT	0x08	/* Enable interrupts from counter/timer. */
#define OPCR_DEFAULT	0x04	/* Enable output data lines; OP3 is timer
				 * output. */
#define CTUR_DEFAULT	0x07	/* Upper timer preload value for TIMER_FREQ. */
#define CTLR_DEFAULT	0x10	/* Lower timer preload value for TIMER_FREQ. */

/* RTS and CTS bit masks. */

#define RTS_A		0x01
#define RTS_B		0x02
#define CTS_A		0x01
#define CTS_B		0x02

/* Define the interrupt level and vector for the DUART chip. */

#define DUART_INT_LVL	5	/* This is hard-wired on the board (74LS148). */
#define DUART_INT_VEC	EXC_USR_INT0	/* The first user interrupt vector. */

#endif
