#ifndef _EXCEPTION_H_
#define _EXCEPTION_H_

/* exception.h - Defines structures related to exception handling. */

#include "reg.h"

#define N_SVEC	64		/* The number of system exception vectors. */
#define N_IVEC	192		/* The number of user interrupt vectors. */
#define N_EVEC	(N_SVEC + N_IVEC)	/* Total number of exception vectors. */

/* Define the exception vectors. */

#define EXC_BUSERR	2	/* Bus error. */
#define EXC_ADDRERR	3	/* Address error. */
#define EXC_ILLINST	4	/* Illegal instruction. */
#define EXC_ZDIV	5	/* Divide by zero. */
#define EXC_CHK		6	/* CHK instruction. */
#define EXC_TRAPV	7	/* TRAPV instruction. */
#define EXC_PRIV	8	/* Privilege violation. */
#define EXC_TRACE	9	/* Trace. */
#define EXC_LINE1010	10	/* Line 1010 emulation. */
#define EXC_LINE1111	11	/* Line 1111 emulation. */
#define EXC_FORMAT	14	/* Format error. */
#define EXC_UNINIT	15	/* Uninitialized interrupt. */
#define EXC_SPUR	24	/* Spurious interrupt. */
#define EXC_AUTO1	25	/* Level 1 autovector. */
#define EXC_AUTO2	26	/* Level 2 autovector. */
#define EXC_AUTO3	27	/* Level 3 autovector. */
#define EXC_AUTO4	28	/* Level 4 autovector. */
#define EXC_AUTO5	29	/* Level 5 autovector. */
#define EXC_AUTO6	30	/* Level 6 autovector. */
#define EXC_AUTO7	31	/* Level 7 autovector. */
#define EXC_TRAP0	32	/* TRAP #0. */
#define EXC_TRAP1	33	/* TRAP #1. */
#define EXC_TRAP2	34	/* TRAP #2. */
#define EXC_TRAP3	35	/* TRAP #3. */
#define EXC_TRAP4	36	/* TRAP #4. */
#define EXC_TRAP5	37	/* TRAP #5. */
#define EXC_TRAP6	38	/* TRAP #6. */
#define EXC_TRAP7	39	/* TRAP #7. */
#define EXC_TRAP8	40	/* TRAP #8. */
#define EXC_TRAP9	41	/* TRAP #9. */
#define EXC_TRAP10	42	/* TRAP #10. */
#define EXC_TRAP11	43	/* TRAP #11. */
#define EXC_TRAP12	44	/* TRAP #12. */
#define EXC_TRAP13	45	/* TRAP #13. */
#define EXC_TRAP14	46	/* TRAP #14. */
#define EXC_TRAP15	47	/* TRAP #15. */
#define EXC_USR_INT0	64	/* User interrupt 0 */
#define EXC_USR_INT1	65	/* User interrupt 1 */
#define EXC_USR_INT2	66	/* User interrupt 2 */
#define EXC_USR_INT3	67	/* User interrupt 3 */
#define EXC_USR_INT4	68	/* User interrupt 4 */
#define EXC_USR_INT5	69	/* User interrupt 5 */
#define EXC_USR_INT6	70	/* User interrupt 6 */
#define EXC_USR_INT7	71	/* User interrupt 7 */
#define EXC_UNASS	N_EVEC	/* Unassigned exception. */

/* Define labels for the three types of MC68000 exception groups. */

#define	EXC_GROUP0	0
#define EXC_GROUP1	1
#define EXC_GROUP2	2
#define EXC_INVALID	3

/* Define symbols to mask and decode Group 0 activity word. */

#define EXC_FUNC_MASK	0x0007	/* Masks off function code bits in activity
				 * word. */
#define EXC_INS_MASK	0x0008	/* Masks off instruction bit in activity
				 * word. */
#define EXC_RW_MASK	0x0010	/* Masks off read/write bit in activity word. */

#define EXC_WRITE	0	/* Exception occurred on a write. */
#define EXC_READ	1	/* Exception occurred on a read. */
#define EXC_INS		0	/* Exception was instruction related. */
#define EXC_NINS	1	/* Exception was non-instruction related. */

/* Macro to compute size of exception frame. */

#define get_frame_size(group)	\
  (((group) == EXC_GROUP0) ? \
  	sizeof(struct exc_frame0) : \
	sizeof(struct exc_frame12))

/* MC68000 Group 0 exception frame. */

struct exc_frame0 {
	short           activity;
	long            addr;
	short           ins;
	short           sr;
	long            pc;
};

/* MC68000 Group 1-2 exception frame. */

struct exc_frame12 {
	short           sr;
	long            pc;
};

/* A structure to hold either type of exception frame structure. */

struct exc_frame {
	union {
		struct exc_frame0 frame0;
		struct exc_frame12 frame12;
	}
	                frame;
	int             group;
	int             vec;
};

#endif
