#ifndef _GLOBALS_H_
#define _GLOBALS_H_

/* 
 * globals.h - Definitions of interest to most programs. 
 */

#define CPU_DESC	"mc68000"
#define TRUE		1
#define FALSE		0

#define NAME_SIZE	32

/* Lengths, in bits, of various sizes of data. */

#define NIBBLE_BITS	4
#define CHAR_BITS	8
#define SHORT_BITS	16
#define INT_BITS	32
#define LONG_BITS	32

/* Definition to make it easier to point at a function. */

typedef void    (*fun_ptr) ();

/* Definitions for testing status register supervisor bit. */

#define SR_SUP_MASK	0x2000	/* Mask for supervisor bit. */
#define CPU_MODE_USR	0	/* Indicates user mode. */
#define CPU_MODE_SUP	1	/* Indicates supervisor mode. */

#define get_cpu_mode(sr)	(((sr) & SR_SUP_MASK) ? \
					CPU_MODE_SUP : CPU_MODE_USR)

#endif
