/* interrupt.c - Support for user interrupts. */

#include "globals.h"
#include "exception.h"

static fun_ptr  Usr_ifunc[N_IVEC];

/*
 * default_ifunc - Default interrupt handler function.
 */
void
default_ifunc()
{
	panic("\ndefault_ifunc: unexpected interrupt.");
}

/*
 * init_ifunc_table - Installs the default handler for all interrupt vectors.
 */
void
init_ifunc_table()
{
	int             i;
	void            default_ifunc();

	for (i = 0; i < N_IVEC; i++)
		Usr_ifunc[i] = default_ifunc;
}

/*
 * install_ifunc - Installs a user interrupt handler function.
 */
void
install_ifunc(vec, func)
	int             vec;
	fun_ptr         func;
{
	Usr_ifunc[vec - N_SVEC] = func;
}

/*
 * call_user_ifunc - Calls a user interrupt handler.
 */
void
call_user_ifunc(vec)
	int             vec;
{
	(*Usr_ifunc[vec - N_SVEC]) ();
}
