#ifndef _KERN_H_
#define _KERN_H_

#include "reg.h"
#include "exception.h"

#define MAX_PRI	16

struct tcb {
	struct tcb *next;
	struct tcb *prev;
	struct pstat pstat;
	int stkbeg;
	int stkend;
	int stksiz;
	int pri;
	int stat;
	char *name;
};

#define TASK_READY	0x1
#define TASK_SUSPEND	0x2

struct tcbq {
	struct tcb *next;
	struct tcb *prev;
};

#define STACK_FENCE_SIZE	16	/* 16 bytes fences around the stack */

struct sem {
	struct tcbq waitq;
	int count;
};

extern void initsys();
extern struct tcb *spawn();
extern void ready();
extern void suspend();
extern struct tcb *pick();
extern void panic();
extern void reschedule();
extern void yield();
extern void run();
extern void kill();
extern void cswitch();
extern void insque();
extern void remque();

#endif
