
/* Kernel test program. */

#include <math.h>
#include "duart.h"
#include "exception.h"

void
main()
{
	int             i;
	int            *cp;
	char            c;
	void            timer_proc();

	/* Install system and user exception vectors. */

	init_vectors();
	install_ifunc(EXC_USR_INT0, timer_proc);

	/* Set up the duart and system timer. */

	init_duart(BAUD9600, BAUD9600);

	/* Print a greeting message. */

	writeln("\r\nStarting test program.");
	writeln("Hello there, how are you?");

	/* Try to generate a trap and recover. */

	writeln("Trying a trap #2...");
	trapit(2);

	/* Now, try a bus error. */

	writeln("\nTrying a bus error...");

	cp = (char *) 0x0d00000;
	i = *cp;
}
