#
# doubly linked-list routines like the ones used in bsd net2
#

#
# insque (element, targetq)
#	element: thing to insert
#	targetq: queue where the thing is insert into
#

	.globl	_insque

TARQ_OFFSET	= 8		| second arg -- target queue ptr
ELEM_OFFSET	= 4		| first arg -- element to insert
PREV_OFFSET	= 4		| offset to prev pointer (after next ptr)

_insque:
	movl	sp@(TARQ_OFFSET),a0	| a0 <- targ
	movl	sp@(ELEM_OFFSET),a1	| a1 <- elem
	movl	a0@,a1@			| elem->next <- targ->next
	movl	a0,a1@(PREV_OFFSET)	| elem->prev <- targ
	movl	a1,a0@			| targ->next <- elem
	movl	a1@,a0			| a0 <- elem->next
	movl	a1,a0@(PREV_OFFSET)	| elem->next->prev = elem
	rts

#
#
#  remque(element)
#	element: to be removed
#

	.globl _remque

_remque:
	movl	sp@(ELEM_OFFSET),a0	| a0 <- element to remove
	movl	a0@,a1			| a1 <- elem->next
	movl	a0@(PREV_OFFSET),a0	| a0 <- elem->prev
	movl	a0,a1@(PREV_OFFSET)	| elem->next->prev <- elem->prev
	movl	a1,a0@			| elem->prev->next <- elem->next
	rts
