/* stat_disp.c - Routines for printing out machine status information. */

#include "globals.h"
#include "exception.h"

/*
 * show_exc_frame - Prints out the contents of the exception frame to the
 * console.
 */
void
show_exc_frame(fp)
	struct exc_frame *fp;
{
	struct exc_frame0 *fp0;
	struct exc_frame12 *fp12;

	printf("exception type group %x\n", fp->group);
	if (fp->group == EXC_GROUP0) {
		fp0 = &fp->frame.frame0;

		printf("pc = %X, sr = %x, addr = %X, ins = %x\n",
		       fp0->pc, fp0->sr, fp0->addr, fp0->ins);

		if ((fp0->activity & EXC_INS_MASK) == EXC_INS)
			printf("instruction ");
		else
			printf("data ");

		if ((fp0->activity & EXC_RW_MASK) == EXC_READ)
			printf("read");
		else
			printf("write");
		putchar('\n');
	} else {
		fp12 = &fp->frame.frame12;
		printf("pc = %X, sr = %x\n", fp12->pc, fp12->sr);
	}
}

/*
 * show_regs - Shows the contents of a 'struct m68k_regs'.
 */
void
show_regs(regs)
	struct m68k_regs *regs;
{
	printf("d0: %X\td1: %X\td2: %X\td3: %X\nd4: %X\td5: %X\t",
	       regs->d0, regs->d1, regs->d2, regs->d3, regs->d4, regs->d5);
	printf("d6: %X\td7: %X\na0: %X\ta1: %X\ta2: %X\ta3: %X\n",
	       regs->d6, regs->d7, regs->a0, regs->a1, regs->a2, regs->a3);
	printf("a4: %X\ta5: %X\ta6: %X\ta7: %X\n",
	       regs->a4, regs->a5, regs->a6, regs->a7);
}

/*
 * show_pstat - display context saved in 'pstat'
 */
void
show_pstat(pstat)
	struct pstat *pstat;
{
	show_regs(&pstat->regs);
	printf("pc: %X\tsr: %X\tusp: %X\tflags: %X\n",
		pstat->pc, pstat->sr, pstat->usp, pstat->flags);
}
