#include "kern.h"

void dumb_fun();
void dweeb_fun();

struct tcb *dummy, *dweeb;
struct tcb dummy_tcb;
struct tcb dweeb_tcb;

#define TESTPRI	1

char dummy_stack[2048];
char dweeb_stack[2048];

struct sem test_sem;

test0()
{
	dummy = spawn(&dummy_tcb, "dummy", dummy_stack, 
			dumb_fun, sizeof(dummy_stack), TESTPRI);
	if (!dummy)
		panic("spawn for dummy failed");

	printf("dummy spawned as %X\n", dummy);

	dweeb = spawn(&dweeb_tcb, "dweeb", dweeb_stack, 
			dweeb_fun, sizeof(dweeb_stack), TESTPRI);
	if (!dweeb)
		panic("spawn for dweeb failed");

	printf("dweeb spawned as %X\n", dweeb);

	run(dummy);
}

void
dumb_fun()
{
	int ix;

	printf("dummy started\n");

	show_time();
	for (ix = 0; ix < 1000; ix++) {
		ready(dweeb);
		yield();
	}
	show_time();
	ready(dweeb);

	sem_init(&test_sem);

	printf("dummy: doing sem_p\n");
	sem_p(&test_sem);

	printf("dummy ending\n");
	exit(0);
}

void
dweeb_fun()
{
	int ix;

	printf("dweeb started\n");

	for (ix = 0; ix < 1000; ix++) {
		ready(dummy);
		yield();
	}

	printf("dweeb: doing sem_v\n");

	sem_v(&test_sem);

	printf("dweeb ending\n");
	exit(0);
}
