/* time.c - Real time clock code. */

#include "duart.h"

static unsigned char Hrs, Mins, Secs;
static int      Ticks = 0;

/* set_time - Set the real time clock to a specific time. */
void
set_time(hrs, mins, secs)
	unsigned char   hrs, mins, secs;
{
	Hrs = hrs;
	Mins = mins;
	Secs = secs;
}

/* get_time - Returns timer values. */
void
get_time(hrs, mins, secs, ticks)
	unsigned char  *hrs, *mins, *secs, *ticks;
{
	*hrs = Hrs;
	*mins = Mins;
	*secs = Secs;
	*ticks = Ticks;
}

/* bump_clock - Advance the real time clock by one second. */
void
bump_clock()
{
	if (++Secs == 60) {
		Secs = 0;

		if (++Mins == 60) {
			Mins = 0;
			if (++Hrs == 24)
				Hrs = 0;
		}
	}
}

/* timer_proc - Receive timer ticks and update clock. */
void
timer_proc()
{
	static int      count = 0;

	/*
	 * Clear the DUART interrupt register in order to turn off the
	 * interrupt.
	 */

	duart_reset_isr();

	/* Accumulate timer ticks. */

	if (++Ticks == TIMER_FREQ) {
		Ticks = 0;
		bump_clock();
	}
}
