#
# trap.s - Routines called immediately after non-user-interrupt exceptions.
#

#
# These routines are called directly by the MC68000 following an exception.
# The 'jsr' to 'push_regs' places the vector address on the stack immediately
# following the exception frame.  This allows the exception handler to determine
# the vector number.  It is the responsibility of the exception handler to
# clean up the stack and restore the user context; 'push_regs' must never
# return.
#

	.globl	_trap2
_trap2:
	jsr	push_regs

	.globl	_trap3
_trap3:
	jsr	push_regs

	.globl	_trap4
_trap4:
	jsr	push_regs

	.globl	_trap5
_trap5:
	jsr	push_regs

	.globl	_trap6
_trap6:
	jsr	push_regs

	.globl	_trap7
_trap7:
	jsr	push_regs

	.globl	_trap8
_trap8:
	jsr	push_regs

	.globl	_trap9
_trap9:
	jsr	push_regs

	.globl	_trap10
_trap10:
	jsr	push_regs

	.globl	_trap11
_trap11:
	jsr	push_regs

SKIP12_13:
	.skip	2 * 6			| Exceptions 12-13 unused.

	.globl	_trap14
_trap14:
	jsr	push_regs

	.globl	_trap15
_trap15:
	jsr	push_regs

SKIP16_23:
	.skip	8 * 6			| Exceptions 16-23 unused.

	.globl	_trap24
_trap24:
	jsr	push_regs

	.globl	_trap25
_trap25:
	jsr	push_regs

	.globl	_trap26
_trap26:
	jsr	push_regs

	.globl	_trap27
_trap27:
	jsr	push_regs

	.globl	_trap28
_trap28:
	jsr	push_regs

	.globl	_trap29
_trap29:
	jsr	push_regs

	.globl	_trap30
_trap30:
	jsr	push_regs

	.globl	_trap31
_trap31:
	jsr	push_regs

	.globl	_trap32
_trap32:
	jsr	push_regs

	.globl	_trap33
_trap33:
	jsr	push_regs

	.globl	_trap34
_trap34:
	jsr	push_regs

	.globl	_trap35
_trap35:
	jsr	push_regs

	.globl	_trap36
_trap36:
	jsr	push_regs

	.globl	_trap37
_trap37:
	jsr	push_regs

	.globl	_trap38
_trap38:
	jsr	push_regs

	.globl	_trap39
_trap39:
	jsr	push_regs

	.globl	_trap40
_trap40:
	jsr	push_regs

	.globl	_trap41
_trap41:
	jsr	push_regs

	.globl	_trap42
_trap42:
	jsr	push_regs

	.globl	_trap43
_trap43:
	jsr	push_regs

	.globl	_trap44
_trap44:
	jsr	push_regs

	.globl	_trap45
_trap45:
	jsr	push_regs

	.globl	_trap46
_trap46:
	jsr	push_regs

	.globl	_trap47
_trap47:
	jsr	push_regs

SKIP48_63:
	.skip	16 * 6			| Exceptions 48-63 unused.

#	For now, provide hooks for the first eight user interrupts.

	.globl	_int0_trap
_int0_trap:
	jsr	push_regs

	.globl	_int1_trap		| User interrupt 1 (vector 65)
_int1_trap:
	jsr	push_regs

	.globl	_int2_trap		| User interrupt 2 (vector 66)
_int2_trap:
	jsr	push_regs

	.globl	_int3_trap		| User interrupt 3 (vector 67)
_int3_trap:
	jsr	push_regs

	.globl	_int4_trap		| User interrupt 4 (vector 68)
_int4_trap:
	jsr	push_regs

	.globl	_int5_trap		| User interrupt 5 (vector 69)
_int5_trap:
	jsr	push_regs

	.globl	_int6_trap		| User interrupt 6 (vector 70)
_int6_trap:
	jsr	push_regs

	.globl	_int7_trap		| User interrupt 7 (vector 71)
_int7_trap:
	jsr	push_regs

SKIP72_255:
	.skip	184 * 6			| Exceptions 72-255 unused.

#
#	Provide a default handler for unassigned interrupts.
#

	.globl	_unass_trap		| Default vector for unassigned traps
_unass_trap:
	jsr	push_regs


