#
#	trapit.s - High level interface to 'trap #n' instruction.
#
	.globl	_trapit		| Called as 'trapit(n)'.

_trapit:
	link	a6,#0
	movel	a6@(8),d0	| Get the trap vector, 'n'.
	asll	#2,d0		| Multiply vector by 4 (offset between trap calls).
	movel	#trap0,a0	| Add the address of the first trap call.
	addl	d0,a0		| Sum base address and offset.
	jra	a0@		| Jump to this address.

done:
	unlk	a6		| Clean up and go home.
	rts

#
#	Sixteen trap instructions to jump to.
#

trap0:
	trap	#0
	jra	done
trap1:
	trap	#1
	jra	done
trap2:
	trap	#2
	jra	done
trap3:
	trap	#3
	jra	done
trap4:
	trap	#4
	jra	done
trap5:
	trap	#5
	jra	done
trap6:
	trap	#6
	jra	done
trap7:
	trap	#7
	jra	done
trap8:
	trap	#8
	jra	done
trap9:
	trap	#9
	jra	done
trap10:
	trap	#10
	jra	done
trap11:
	trap	#11
	jra	done
trap12:
	trap	#12
	jra	done
trap13:
	trap	#13
	jra	done
trap14:
	trap	#14
	jra	done
trap15:
	trap	#15
	jra	done
