/* vector.c - Routines for installing exception vectors. */

#include "globals.h"
#include "exception.h"

/* install_vector - Installs an exception vector. */

void
install_vector(n, func)
	int             n;
	fun_ptr         func;
{
	fun_ptr        *vec_addr;
	char            addr_str[9], func_str[9];

	/* Compute the vector table address. */
	vec_addr = (fun_ptr *) (n << 2);

	/* Install the vector. */
	*vec_addr = func;
}

/* init_vectors - Install system and user exception vectors. */
void
init_vectors()
{
	int             i;
	void            trap2(), trap3(), trap4(), trap5(), trap6(), trap7();
	void            trap8(), trap9(), trap10();
	void            trap11(), trap14(), trap15(), trap24(), trap25();
	void            trap26(), trap27(), trap28();
	void            trap29(), trap30(), trap31(), trap32(), trap33();
	void            trap34(), trap35(), trap36();
	void            trap37(), trap38(), trap39(), trap40(), trap41();
	void            trap42(), trap43(), trap44();
	void            trap45(), trap46(), trap47(), int0_trap(), int1_trap();
	void            int2_trap(), int3_trap();
	void            int4_trap(), int5_trap(), int6_trap(), int7_trap();
	void            unass_trap();

	/* First, fill all vector entires with unassigned interrupt trap. */
	for (i = 0; i < N_EVEC; i++)
		install_vector(i, unass_trap);

	/* Now, install the assigned exception vectors.  Not all 48 are used. */

	install_vector(EXC_BUSERR, trap2);
	install_vector(EXC_ADDRERR, trap3);
	install_vector(EXC_ILLINST, trap4);
	install_vector(EXC_ZDIV, trap5);
	install_vector(EXC_CHK, trap6);
	install_vector(EXC_TRAPV, trap7);
	install_vector(EXC_PRIV, trap8);
	install_vector(EXC_TRACE, trap9);
	install_vector(EXC_LINE1010, trap10);
	install_vector(EXC_LINE1111, trap11);
	install_vector(EXC_FORMAT, trap14);
	install_vector(EXC_UNINIT, trap15);
	install_vector(EXC_SPUR, trap24);
	install_vector(EXC_AUTO1, trap25);
	install_vector(EXC_AUTO2, trap26);
	install_vector(EXC_AUTO3, trap27);
	install_vector(EXC_AUTO4, trap28);
	install_vector(EXC_AUTO5, trap29);
	install_vector(EXC_AUTO6, trap30);
	install_vector(EXC_AUTO7, trap31);
	install_vector(EXC_TRAP0, trap32);
	install_vector(EXC_TRAP1, trap33);
	install_vector(EXC_TRAP2, trap34);
	install_vector(EXC_TRAP3, trap35);
	install_vector(EXC_TRAP4, trap36);
	install_vector(EXC_TRAP5, trap37);
	install_vector(EXC_TRAP6, trap38);
	install_vector(EXC_TRAP7, trap39);
	install_vector(EXC_TRAP8, trap40);
	install_vector(EXC_TRAP9, trap41);
	install_vector(EXC_TRAP10, trap42);
	install_vector(EXC_TRAP11, trap43);
	install_vector(EXC_TRAP12, trap44);
	install_vector(EXC_TRAP13, trap45);
	install_vector(EXC_TRAP14, trap46);
	install_vector(EXC_TRAP15, trap47);

	/* Install the first eight user interrupt vectors. */

	install_vector(EXC_USR_INT0, int0_trap);
	install_vector(EXC_USR_INT1, int1_trap);
	install_vector(EXC_USR_INT2, int2_trap);
	install_vector(EXC_USR_INT3, int3_trap);
	install_vector(EXC_USR_INT4, int4_trap);
	install_vector(EXC_USR_INT5, int5_trap);
	install_vector(EXC_USR_INT6, int6_trap);
	install_vector(EXC_USR_INT7, int7_trap);

	/* Initialize the user interrupt function table. */

	init_ifunc_table();
}
