/*
 *  $Id$
 */

/*
 * Copyright (c) 1991 - 1994 by Jayasooriah
 */


/*
 * =====================================================================
 * Contents
 *
 *	Interface for Motorola 68340 Integrated Processor
 *
 * End of Contents
 * =====================================================================
 */


/*
 * =====================================================================
 * Interface Dependencies
 */

/*
 * End of Interface Dependencies
 * =====================================================================
 */


/*
 * =====================================================================
 * Manifests
 */


/*
 * End Of Manifests
 * =====================================================================
 */


/*
 * =====================================================================
 * Types
 */

typedef union serialModuleTag serialModule;

/*
 * End Of Types
 * =====================================================================
 */


/*
 * =====================================================================
 * Shapes
 */

/*
 * Serial Module Register Interface - MC68350UM/AD Rev 1 page 7-19
 */
 
/* serial module read registers */
struct serialModuleReadTag
{
	unsigned char mcrh;	/* module config register (high) */
	unsigned char mcrl;	/* module config register (low) */
	unsigned char byte02;	/* do not access */
	unsigned char byte03;	/* do not access */
	unsigned char ilr;	/* interrupt level register */
	unsigned char ivr;	/* interrupt vector register */
	unsigned char byte06;	/* unused */
	unsigned char byte07;	/* unused */
	unsigned char byte08;	/* unused */
	unsigned char byte09;	/* unused */
	unsigned char byte0A;	/* unused */
	unsigned char byte0B;	/* unused */
	unsigned char byte0C;	/* unused */
	unsigned char byte0D;	/* unused */
	unsigned char byte0E;	/* unused */
	unsigned char byte0F;	/* unused */
	unsigned char mr1a;	/* mode register 1A */
	unsigned char sra;	/* status register A */
	unsigned char byte12;	/* do not access */
	unsigned char rba;	/* receive buffer A */
	unsigned char ipcr;	/* input port change register */
	unsigned char isr;	/* interrupt status register */
	unsigned char byte16;	/* do not access */
	unsigned char byte17;	/* do not access */
	unsigned char mr1b;	/* mode register 1B */
	unsigned char srb;	/* status register B */
	unsigned char byte1a;	/* do not access */
	unsigned char rbb;	/* receive buffer B */
	unsigned char byte1c;	/* do not access */
	unsigned char ip;	/* input port register */
	unsigned char byte1e;	/* do not access */
	unsigned char byte1f;	/* do not access */
	unsigned char mr2a;	/* mode register 2A */
	unsigned char mr2b;	/* mode register 2B */
};


/* serial module write registers */
struct serialModuleWriteTag
{
	unsigned char mcrh;	/* module config register (high) */
	unsigned char mcrl;	/* module config register (low) */
	unsigned char byte02;	/* do not access */
	unsigned char byte03;	/* do not access */
	unsigned char ilr;	/* interrupt level register */
	unsigned char ivr;	/* interrupt vector register */
	unsigned char byte06;	/* unused */
	unsigned char byte07;	/* unused */
	unsigned char byte08;	/* unused */
	unsigned char byte09;	/* unused */
	unsigned char byte0A;	/* unused */
	unsigned char byte0B;	/* unused */
	unsigned char byte0C;	/* unused */
	unsigned char byte0D;	/* unused */
	unsigned char byte0E;	/* unused */
	unsigned char byte0F;	/* unused */
	unsigned char mr1a;	/* mode register 1A */
	unsigned char csra;	/* clock-select register A */
	unsigned char cra;	/* command register A */
	unsigned char tba;	/* transmit buffer A */
	unsigned char acr;	/* auxiliary control register */
	unsigned char ier;	/* interrupt enable register */
	unsigned char byte16;	/* do not access */
	unsigned char byte17;	/* do not access */
	unsigned char mr1b;	/* mode register 1B */
	unsigned char csrb;	/* clock select register B */
	unsigned char crb;	/* command register B */
	unsigned char tbb;	/* transmit buffer B */
	unsigned char byte1c;	/* do not access */
	unsigned char opcr;	/* output port control register */
	unsigned char opbs;	/* output port bit set */
	unsigned char opbr;	/* output port bit reset */
	unsigned char mr2a;	/* mode register 2A */
	unsigned char mr2b;	/* mode register 2B */
};

union serialModuleTag
{
	struct serialModuleReadTag r;
	struct serialModuleWriteTag w;
};


/*
 * End of Shapes
 * =====================================================================
 */


/*
 * =====================================================================
 * Common
 */


/*
 * End of Common
 * =====================================================================
 */


/*
 * =====================================================================
 * Functions
 */


/*
 * End of Functions
 * =====================================================================
 */
