/*************************************************************************************
**																					**
**				cogito Gesellschaft fr Elektronikentwicklung mbH					**
**	  																				**
**						LCD HD61830 Routines for MC68XXX Embedded-Controller		**
**																					**
**							File			: HD61830S.S							**
**							Author			: Frank Sautter							**
**							Version			: 1.10									**
**							First Byte		: 26.07.93								**
**							Latest Change	: 18.01.94								**
**																					**
**																					**		
*************************************************************************************/

			include		"mc683xx.sh"
			include		"dds_crtr.sh"

			export		lcd_nol
			export		lcd_str
			export		lcd_g_init
			export		lcd_t_init
			
lcd_mode	equ			$f00000
lcd_busy	equ			$f00001
lcd_instr	equ			$f00001

/************************************************************************************
 *	Initializing LC Display into graphic mode										* 
 ************************************************************************************/

lcd_g_init:	move.w		#$f000,sim_csbar2				;SIM-CSBAR2 2k-Blocksize LCD Base $f00
			move.w		#%0111110001110000,sim_csor2	;SIM-CSOR2 R/W

			bsr			lcd_cbsy
			move.b		#$0,lcd_instr
			move.b		#%110010,lcd_mode

			bsr			lcd_cbsy
			move.b		#$1,lcd_instr
			move.b		#$07,lcd_mode
			
			bsr			lcd_cbsy
			move.b		#$2,lcd_instr
			move.b		#29,lcd_mode
			
			bsr			lcd_cbsy
			move.b		#$3,lcd_instr
			move.b		#127,lcd_mode
			
			bsr			lcd_cbsy
			move.b		#$8,lcd_instr
			move.b		#$00,lcd_mode
			
			bsr			lcd_cbsy
			move.b		#$9,lcd_instr
			move.b		#$00,lcd_mode
			
			rts

			
/************************************************************************************
 *	Initializing LC Display into text mode											* 
 ************************************************************************************/

lcd_t_init:	move.w		#$f000,sim_csbar2				;SIM-CSBAR2 2k-Blocksize LCD Base $f00
			move.w		#%0111110001110000,sim_csor2	;SIM-CSOR2 R/W

			bsr			lcd_cbsy
			move.b		#$0,lcd_instr
			move.b		#%110000,lcd_mode

			bsr			lcd_cbsy
			move.b		#$1,lcd_instr
			move.b		#$75,lcd_mode
			
			bsr			lcd_cbsy
			move.b		#$2,lcd_instr
			move.b		#39,lcd_mode
			
			bsr			lcd_cbsy
			move.b		#$3,lcd_instr
			move.b		#127,lcd_mode
			
			bsr			lcd_cbsy
			move.b		#$4,lcd_instr
			move.b		#7,lcd_mode
			
			bsr			lcd_cbsy
			move.b		#$8,lcd_instr
			move.b		#$00,lcd_mode
			
			bsr			lcd_cbsy
			move.b		#$9,lcd_instr
			move.b		#$00,lcd_mode
			
			bsr			lcd_clr
			rts
			
/************************************************************************************
 *	Writing string to LCD				 											* 
 *	d0:	Spaltenposition																*
 *	d1:	Zeilenposition																*
 *	a0:	Stringaddress																*
 ************************************************************************************/

lcd_str:	mulu.w		#40,d1
			add.w		d0,d1

			bsr			lcd_cbsy
			move.b		#$a,lcd_instr
			move.b		d1,lcd_mode

			lsr.w		#8,d1

			bsr			lcd_cbsy
			move.b		#$b,lcd_instr
			move.b		d1,lcd_mode

			move.b		#$c,lcd_instr
			
.bra01:		move.b		(a0)+,d0
			beq.s		.bra03
.bra02:		btst		#7,lcd_busy
			bne.s		.bra02
			move.b		d0,lcd_mode
			bra.s		.bra01
			
.bra03:		rts


/************************************************************************************
 *	Copy virtual screen to LCD			 											* 
 *	a0:	screenaddresss																*
 ************************************************************************************/

		
lcd_cs:		bsr			lcd_cbsy
			move.b		#$a,lcd_instr
			move.b		#0,lcd_mode

			bsr			lcd_cbsy
			move.b		#$b,lcd_instr
			move.b		#0,lcd_mode

			move.b		#$c,lcd_instr
			
			move.w		#3839,d0
.bra01:		btst		#7,lcd_busy
			bne.s		.bra01
			move.b		(a0)+,lcd_mode
			dbra		d0,.bra01
			rts


/************************************************************************************
 *	Check busyflag																	*
 ************************************************************************************/

lcd_cbsy:	btst		#7,lcd_busy
			bne.s		lcd_cbsy
			rts


/************************************************************************************
 *	Clearing LCD																	*
 ************************************************************************************/

lcd_clr:	bsr			lcd_cbsy
			move.b		#$a,lcd_instr
			move.b		#0,lcd_mode

			bsr			lcd_cbsy
			move.b		#$b,lcd_instr
			move.b		#0,lcd_mode

			move.b		#$c,lcd_instr
			
			move.w		#8191,d0
.bra01:		btst		#7,lcd_busy
			bne.s		.bra01
			move.b		#0,lcd_mode
			dbra		d0,.bra01
			rts


/************************************************************************************
 *	Writing LCD display data														*
 ************************************************************************************/

lcd_wdd:	rts

/************************************************************************************
 *	Reading LCD display data adress													*
 ************************************************************************************/

lcd_rdda:	rts

/************************************************************************************
 *	Writing LCD controlword															*
 ************************************************************************************/

lcd_ctrl:	rts

/************************************************************************************
 *	Datenbereich																	*
 ************************************************************************************/

			.bss
lcd_nol:	ds.w		1

/************************************************************************************/

/************************************************************************************/

