/*************************************************************************************
**																					**
**				cogito Gesellschaft fr Elektronikentwicklung mbH					**
**	  																				**
**						LCD HD44780 Routines for MC68XXX Embedded-Controller		**
**																					**
**							File			: LCD.C									**
**							Author			: Frank Sautter							**
**							Version			: 1.10									**
**							First Byte		: 26.07.93								**
**							Latest Change	: 25.12.93								**
**																					**
**																					**		
*************************************************************************************/

#include	<stdarg.h>
#include	<string.h>
#include	<stdio.h>
#include	<portab.h>
#include	"lcd_s.h"

extern WORD lcd_nol;

/************************************************************************************
 *	printf() auf CAT-device emul(g)ieren											*
 *	-> device, format-string, arg, ...												*
 *	<- void																			*
 ************************************************************************************/

void lcd_printf(UWORD line, const UBYTE *fmt, ...)
{
	static UBYTE string[200];			/* aus Geschwindigkeitsgrnden statisch...	*/
	va_list args;						/* rks!									*/
	
	va_start(args, fmt);				/* av-pointer grabschen						*/
	vsprintf(string, fmt, args);		/* und gleich weiterverscheuern				*/
	va_end(args);						/* va-list dichtmachen						*/

	lcd_str(0,line,string);					/* und den gebastelten string raushauen		*/

/*	lcd_string(string, line);			/* und den gebastelten string raushauen		*/*/
}

/************************************************************************************
 *	LCD String ausgeben																*
 ************************************************************************************/

void lcd_string(UBYTE *string, UWORD line)
{	UWORD i=0,ps=0,nb;
	
	switch(line)
	{	case 1:		lcd_ctrl(0x80); ps=1; break;	/* Verschiedene Zeilenanfnge setzen */
		case 2:		lcd_ctrl(0xc0); ps=1; break;
		case 3:		lcd_ctrl(0x90); ps=1; break;
		case 4:		lcd_ctrl(0xd0); ps=1; break;
	}
	
	while(*(string+i)!=0)
	{	if(ps==0 && lcd_nol!=1)
		{	switch(lcd_rdda())
			{	case 0x10:	lcd_ctrl(0xc0); break;	/* Zeilenberlauf */
				case 0x50:	lcd_ctrl(0x90); break;
				case 0x20:	lcd_ctrl(0xd0); break;
				case 0x60:	lcd_ctrl(0x80); break; 
			}
		}
		
		nb=*(string+i++);

		if(lcd_nol==1)
		{	switch(nb)
			{	case 0x67: nb=0xe7; break;
				case 0x70: nb=0xf0; break;
				case 0x71: nb=0xf1; break;
				case 0x79: nb=0xf9; break;
			}
		}
		else
		{	switch(nb)
			{	case 0x67: nb=0x0b; break;
				case 0x70: nb=0x0c; break;
				case 0x71: nb=0x0d; break;
				case 0x79: nb=0x0e; break;
			}
		}
		lcd_wdd(nb);
		ps=0;
	}
}

/************************************************************************************
 *	LCD Zeichen in Charactergenerator schreiben										*
 ************************************************************************************/

void lcd_cgload(UBYTE *load, UWORD character)
{	UWORD i=0,pos;

	character&=0x07;
	pos=lcd_rdda();								/* Alte Cursorposition merken */
	lcd_ctrl(((character*8) & 0x38) | 0x40);
	
	while(*(load+i)!=0)
	{	lcd_wdd((*(load+i++) & 0x1f));
	}
	
	lcd_ctrl(pos | 0x80);						/* Alte Cursorposition wiederherstellen */
}

/************************************************************************************/
