/*************************************************************************************
**																					**
**				cogito Gesellschaft fr Elektronikentwicklung mbH					**
**	  																				**
**						LCD HD44780 Routines for MC68XXX Embedded-Controller		**
**																					**
**							File			: LCD_S.S								**
**							Author			: Frank Sautter							**
**							Version			: 1.10									**
**							First Byte		: 26.07.93								**
**							Latest Change	: 24.12.93								**
**																					**
**																					**		
*************************************************************************************/

			include		"mc683xx.sh"

			export		lcd_nol

lcd_contr	equ			$f00000
lcd_busy	equ			$f00000
lcd_rw		equ			$f00001

/************************************************************************************
 *	Initialising Keypad																*
 ************************************************************************************/

key_init:	move.b		#$00,sim_pepar
			move.b		#$00,sim_ddre
			move.b		#$00,sim_pfpar
			move.b		#$0e,sim_portf
			move.b		#$0e,sim_ddrf
			rts

/************************************************************************************
 *	Reading Keypad																	*
 ************************************************************************************/

key_read:	moveq.l		#0,d0			;Read once
			move.b		sim_porte,d0
			lsl.w		#8,d0
			move.b		sim_portf,d0
			lsr.w		#4,d0

			moveq.l		#0,d1			;And twice
			move.b		sim_porte,d1
			lsl.w		#8,d1
			move.b		sim_portf,d1
			lsr.w		#4,d1

			cmp.w		d0,d1			;prellende Taste
			bne.s		key_read

			eor.w		#$0fff,d0
			rts

/************************************************************************************
 *	Initializing LC Display															* 
 *	d0 = 1Line LCD 5x10 Characters													*
 *	d0 = 2Line LCD 5x7 Characters													*
 ************************************************************************************/

lcd_init:	move.w		#$f000,sim_csbar2				;SIM-CSBAR2 2k-Blocksize LCD Base $f00
			move.w		#%0111111101110000,sim_csor2	;SIM-CSOR2 R/W


			move.w		d0,lcd_nol
			cmp.w		#1,d0
			bne.s		.twolines

			move.b		#$34,lcd_contr
			move.w		#$f000,d0
.wait1:		dbra		d0,.wait1

			move.b		#$34,lcd_contr
			move.w		#$f000,d0
.wait2:		dbra		d0,.wait2

			move.b		#$34,lcd_contr
			move.w		#$f000,d0
.wait3:		dbra		d0,.wait3

			move.b		#$0c,d0
			bsr			lcd_ctrl			

			move.b		#$06,d0
			bsr			lcd_ctrl			

			move.b		#$01,d0
			bsr			lcd_ctrl			

			move.l		#0,d0
			rts

.twolines:	move.b		#$38,lcd_contr
			move.w		#$f000,d0
.wait4:		dbra		d0,.wait4

			move.b		#$38,lcd_contr
			move.w		#$f000,d0
.wait5:		dbra		d0,.wait5

			move.b		#$38,lcd_contr
			move.w		#$f000,d0
.wait6:		dbra		d0,.wait6

			move.b		#$0c,d0
			bsr			lcd_ctrl			

			move.b		#$06,d0
			bsr			lcd_ctrl			

			move.b		#$01,d0
			bsr			lcd_ctrl			

			move.l		#0,d0
			rts

/************************************************************************************
 *	Clearing LCD																	*
 ************************************************************************************/

lcd_clr:	btst.b		#7,lcd_busy
			bne.s		lcd_clr
			move.b		#$01,lcd_contr

			moveq.l		#0,d0
			rts

/************************************************************************************
 *	Writing LCD display data														*
 ************************************************************************************/

lcd_wdd:	btst.b		#7,lcd_busy
			bne.s		lcd_wdd
			move.b		d0,lcd_rw

			rts

/************************************************************************************
 *	Reading LCD display data adress													*
 ************************************************************************************/

lcd_rdda:	btst.b		#7,lcd_busy
			bne.s		lcd_rdda

			move.b		lcd_busy,d0
			and.w		#$7f,d0

			rts

/************************************************************************************
 *	Writing LCD controlword															*
 ************************************************************************************/

lcd_ctrl:	btst.b		#7,lcd_busy
			bne.s		lcd_ctrl
			move.b		d0,lcd_contr

			moveq.l		#0,d0
			rts

/************************************************************************************
 *	Datenbereich																	*
 ************************************************************************************/

			.bss
lcd_nol:	ds.w		1

/************************************************************************************/

