/*************************************************************************************
**																					**
**				cogito Gesellschaft fr Elektronikentwicklung mbH					**
**	  																				**
**							Hardware Definition File for MC683XX Series				**
**																					**
**							File			: MC683XX.H								**
**							Author			: Frank Sautter							**
**							Version			: 1.10									**
**							First Byte		: 02.07.93								**
**							Latest Change	: 18.12.93								**
**																					**
**																					**		
*************************************************************************************/

/*************************************************************************************
**	Hardwarekonstanten																**
*************************************************************************************/

#define 	BASEPAGE		0x0l
#define 	GPT				0xfff900l		/* GPT Base							*/
#define 	SIM				0xfffa00l		/* SIM Base							*/
#define		RAM_CTRL		0xfffb00l		/* RAM CTRL Base					*/
#define 	QSM				0xfffc00l		/* QSM Base							*/
#define		TPU				0xfffe00l		/* TPU Base							*/

/*************************************************************************************
**	Adresszuweisungen der Hardwarestrukturen										**
*************************************************************************************/

extern volatile T_BASEPAGE	* const base_p;
extern volatile T_GPT		* const qpt;
extern volatile T_SIM		* const sim;
extern volatile T_RAM_CTRL	* const ram_ctrl;
extern volatile T_QSM		* const qsm;
extern volatile T_TPU		* const tpu;


/*************************************************************************************
**	Typdeklarationen der Hardwarestruktur											**
*************************************************************************************/

typedef struct								/* baspage und Ex-Vektoren			*/
{	ULONG	reset_ssp,						/* Stackpointer nach Reset			*/
			reset_pc,						/* PC nach Reset					*/
			bus_error,						/* Busfehler						*/
			adr_error,						/* Adressfehler						*/
			ill_instr,						/* Ilegale Instruktion				*/
			div_by_zero,					/* Division durch 0					*/
			chk,							/* CHK-Befehl						*/
			trapv,							/* trapv-Befehl						*/
			priv_viol,						/* Privilegverletzung				*/
			trace,							/* Trace-Kommando					*/
			line_a,							/* $axxx Kommando					*/
			line_f,							/* $fxxx Kommando					*/
			resvd1,							/* Reserviert						*/
			resvd2,
			form_error,						/* Formatfehler						*/
			ninit_inter,					/* Nichtinstallierter Interrupt		*/
			resvd3,							/* Reserviert						*/
			resvd4,
			resvd5,
			resvd6,
			resvd7,
			resvd8,
			resvd9,
			spur_inter,						/* Nicht lokalisierbarer Interrupt	*/
			lev_1_inter,					/* Autovektor-Interrupts			*/
			lev_2_inter,					/* Level 1 bis 7					*/
			lev_3_inter,
			lev_4_inter,
			lev_5_inter,
			lev_6_inter,
			lev_7_inter,
			trap_0,							/* Trap-Kommando					*/
			trap_1,							/* Trap #0 bis Trap #7				*/
			trap_2,
			trap_3,
			trap_4,
			trap_5,
			trap_6,
			trap_7,
			trap_8,
			trap_9,
			trap_10,
			trap_11,
			trap_12,
			trap_13,
			trap_14,
			trap_15,
			res[16];						/* Padding reservierter Bereich		*/
}T_BASEPAGE;



#if ( MC68XXX==331 )

typedef struct 
{	UWORD	gmcr;							/* GPT Module Configuration			*/
	UWORD	rsvd1;
	UWORD	gicr;							/* GPT Interrupt Configuration		*/
	UBYTE	gpddr;							/* GPT Port Data Direction			*/
	UBYTE	gpdr;							/* GPT Port Data Register			*/
	UBYTE	goc1m;							/* GPT Action Mask					*/
	UBYTE	goc1d;							/* GPT Action Data					*/
	UWORD	gtcnt;							/* GPT Timer Counter				*/
	UBYTE	gpactl;							/* GPT Pulse Accumulator Control	*/
	UBYTE	gpacnt;							/* GPT Pulse Accumulator Counter	*/
	UWORD	gtic1;							/* GPT Input Capture 1				*/
	UWORD	gtic2;							/* GPT Input Capture 2				*/
	UWORD	gtic2;							/* GPT Input Capture 3				*/
	UWORD	gtoc1;							/* GPT Output Capture 1				*/
	UWORD	gtoc2;							/* GPT Output Capture 2				*/
	UWORD	gtoc3;							/* GPT Output Capture 3				*/
	UWORD	gtoc4;							/* GPT Output Capture 4				*/
	UWORD	gti4o5;							/* GPT Input 4 Output 5 Capture		*/
	UBYTE	gtctl1;							/* GPT Timer Control 1				*/
	UBYTE	gtctl2;							/* GPT Timer Control 2				*/
	UBYTE	gtmsk1;							/* GPT Timer Interrupt Mask 1		*/
	UBYTE	gtmsk2;							/* GPT Timer Interrupt Mask 2		*/
	UBYTE	gtflg1;							/* GPT Timer Interrupt Flag 1		*/
	UBYTE	gtflg2;							/* GPT Timer Interrupt Flag 2		*/
	UBYTE	gcforc;							/* GPT Compare Force				*/
	UBYTE	gpwwc;							/* GPT PWM Control					*/
	UBYTE	gpwwa;							/* GPT PWMA Register				*/
	UBYTE	gpwwb;							/* GPT PWMB Register				*/
	UWORD	gpwmcnt;						/* GPT PWM Count					*/
	UBYTE	gwmabuf;						/* GPT PWMA Buffer					*/
	UBYTE	gwmbbuf;						/* GPT PWMB Buffer					*/
	UWORD	gprescl;						/* GPT Prescaler					*/
}T_GPT;

#emdif



#if ( MC68XXX==331 || MC68XXX==332 )

typedef struct 
{	UWORD	mcr;							/* Module Configuration				*/
	UWORD	simtr;							/* Module Test						*/
	UWORD	syncr;							/* Clock Synthesizer Control		*/
	UBYTE	rsvd1;
	UBYTE	rsr;							/* Reset Status Register			*/
	UWORD	simtre;							/* Module Test E					*/
	UWORD	rsvd2;
	UWORD	rsvd3;
	UWORD	rsvd4;
	UWORD	rsvd5;
	UBYTE	rsvd6;
	UBYTE	porte;							/* Port E Data						*/
	UBYTE	rsvd7;
	UBYTE	ddre;							/* Port E Data Direction			*/
	UBYTE	rsvd8;
	UBYTE	pepar;							/* Port E Pin Assignment			*/
	UWORD	rsvd9;
	UBYTE	rsvd10;
	UBYTE	portf;							/* Port F Data						*/
	UBYTE	rsvd11;
	UBYTE	ddrf;							/* Port F Data Direction			*/
	UBYTE	rsvd12;
	UBYTE	pfpar;							/* Port F Pin Assignment			*/
	UBYTE	rsvd13;
	UBYTE	sypcr;							/* System Protection Control		*/
	UWORD	picr;							/* Periodic Interrupt Control		*/
	UWORD	pitr;							/* Periodic Interrupt Timing		*/
	UBYTE	rsvd14;
	UBYTE	swsr;							/* Software Service					*/
	UWORD	rsvd15;
	UWORD	tstmsra;						/* Test Module Master Shift A		*/
	UWORD	tstmsrb;						/* Test Module Master Shift B		*/
	UBYTE	tstsca;							/* Test Module Shift Count A		*/
	UBYTE	tstscb;							/* Test Module Shift Count B		*/
	UWORD	tstrc;							/* Test Module Repetition Count		*/
	UWORD	tstcreg;						/* Test Module Control Register		*/
	UWORD	tstdreg;						/* Test Module Distributed Register	*/
	UWORD	rsvd16;
	UWORD	rsvd17;
	UBYTE	rsvd18;
	UBYTE	cspdr;							/* Port C Data						*/
	UWORD	rsvd19;
	UWORD	cspar0;							/* Chip Select Pin Assignment 0		*/
	UWORD	cspar1;							/* Chip Select Pin Assignment 1		*/
	UWORD	csbarbt;						/* Chip Select Base Boot			*/
	UWORD	csorbt;							/* Chip Select Option Boot			*/
	UWORD	csbar0;							/* Chip Select Base 0				*/
	UWORD	csor0;							/* Chip Select Option 0				*/
	UWORD	csbar1;							/* Chip Select Base 1				*/
	UWORD	csor1;							/* Chip Select Option 1				*/
	UWORD	csbar2;							/* Chip Select Base 2				*/
	UWORD	csor2;							/* Chip Select Option 2				*/
	UWORD	csbar3;							/* Chip Select Base 3				*/
	UWORD	csor3;							/* Chip Select Option 3				*/
	UWORD	csbar4;							/* Chip Select Base 4				*/
	UWORD	csor4;							/* Chip Select Option 4				*/
	UWORD	csbar5;							/* Chip Select Base 5				*/
	UWORD	csor5;							/* Chip Select Option 5				*/
	UWORD	csbar6;							/* Chip Select Base 6				*/
	UWORD	csor6;							/* Chip Select Option 6				*/
	UWORD	csbar7;							/* Chip Select Base 7				*/
	UWORD	csor7;							/* Chip Select Option 7				*/
	UWORD	csbar8;							/* Chip Select Base 8				*/
	UWORD	csor8;							/* Chip Select Option 8				*/
	UWORD	csbar9;							/* Chip Select Base 9				*/
	UWORD	csor9;							/* Chip Select Option 9				*/
	UWORD	csbar10;						/* Chip Select Base 10				*/
	UWORD	csor10;							/* Chip Select Option 10			*/
	UWORD	rsvd20;
	UWORD	rsvd21;
	UWORD	rsvd22;
	UWORD	rsvd23;
}T_SIM;

#endif



#if ( MC68XXX==331 || MC68XXX==332 )

typedef struct 
{	UWORD	qmcr;							/* QSM Module Configuration			*/
	UWORD	qtest;							/* QSM Test							*/
	UBYTE	qilr;							/* QSM Interrupt Level				*/
	UBYTE	qivr;							/* QSM Interrupt Vector				*/
	UWORD	rsvd1;
	UWORD	sccr0;							/* SCI Control 0					*/
	UWORD	sccr1;							/* SCI Control 1					*/
	UWORD	scsr;							/* SCI Status						*/
	UWORD	scdr;							/* SCI Data							*/
	UWORD	rsvd2;
	UWORD	rsvd3;
	UBYTE	rsvd4;
	UBYTE	qpdr;							/* QSM Port Data					*/
	UBYTE	qpar;							/* QSM Pin Assignment				*/
	UBYTE	cspdr;							/* QSM Data Direction				*/
	UWORD	spcr0;							/* QSPI Control 0					*/
	UWORD	spcr1;							/* QSPI Control 1					*/
	UWORD	spcr2;							/* QSPI Control 2					*/
	UBYTE	spcr3;							/* QSPI Control 3					*/
	UBYTE	spsr;							/* QSPI Status						*/
	UWORD	rsvd5[224];
	UWORD	rec[32];						/* QSPI Receive RAM					*/
	UWORD	tran[32];						/* QSPI Transfer RAM				*/
	UBYTE	comd[32];						/* QSPI Command RAM					*/
}T_QSM;

#endif

