/*************************************************************************************
**																					**
**				cogito Gesellschaft fr Elektronikentwicklung mbH					**
**	  																				**
**							Hardware Definition File for MC683XX Series				**
**																					**
**							File			: MC683XX.SH							**
**							Author			: Frank Sautter							**
**							Version			: 1.10									**
**							First Byte		: 15.07.93								**
**							Latest Change	: 27.12.93								**
**																					**
**																					**		
*************************************************************************************/

/************************************************************************************
 *	MC683XX Opcodes																	*
 ************************************************************************************/

bgnd			equ		$4afa

/************************************************************************************
 *	Defines																			*
 ************************************************************************************/

gptbase			equ		$fff900.w
simbase			equ		$fffa00.w
ramctrlbase		equ		$fffb00.w
qsmbase			equ		$fffc00.w
tpubase			equ		$fffe00.w
tpuparbase		equ		$ffff00.w


/************************************************************************************/

gpt_gmcr		equ		gptbase					/* GPT Module Configuration			*/
gpt_icr			equ		gptbase+$04				/* GPT Interrupt Configuration		*/
gpt_pddr		equ		gptbase+$06				/* GPT Port Data Direction			*/
gpt_pdr			equ		gptbase+$07				/* GPT Port Data Register			*/
gpt_oc1m		equ		gptbase+$08				/* GPT Action Mask					*/
gpt_oc1d		equ		gptbase+$09				/* GPT Action Data					*/
gpt_tcnt		equ		gptbase+$0a				/* GPT Timer Counter				*/
gpt_pactl		equ		gptbase+$0c				/* GPT Pulse Accumulator Control	*/
gpt_pacnt		equ		gptbase+$0d				/* GPT Pulse Accumulator Counter	*/
gpt_tic1		equ		gptbase+$0e				/* GPT Input Capture 1				*/
gpt_tic2		equ		gptbase+$10				/* GPT Input Capture 2				*/
gpt_tic3		equ		gptbase+$12				/* GPT Input Capture 3				*/
gpt_toc1		equ		gptbase+$14				/* GPT Output Capture 1				*/
gpt_toc2		equ		gptbase+$16				/* GPT Output Capture 2				*/
gpt_toc3		equ		gptbase+$18				/* GPT Output Capture 3				*/
gpt_toc4		equ		gptbase+$1a				/* GPT Output Capture 4				*/
gpt_ti4o5		equ		gptbase+$1c				/* GPT Input 4 Output 5 Capture		*/
gpt_tctl1		equ		gptbase+$1e				/* GPT Timer Control 1				*/
gpt_tctl2		equ		gptbase+$1f				/* GPT Timer Control 2				*/
gpt_tmsk1		equ		gptbase+$20				/* GPT Timer Interrupt Mask 1		*/
gpt_tmsk2		equ		gptbase+$21				/* GPT Timer Interrupt Mask 2		*/
gpt_tflg1		equ		gptbase+$22				/* GPT Timer Interrupt Flag 1		*/
gpt_tflg2		equ		gptbase+$23				/* GPT Timer Interrupt Flag 2		*/
gpt_cforc		equ		gptbase+$24				/* GPT Compare Force				*/
gpt_pwmc		equ		gptbase+$25				/* GPT PWM Control					*/
gpt_pwma		equ		gptbase+$26				/* GPT PWMA Register				*/
gpt_pwmb		equ		gptbase+$27				/* GPT PWMB Register				*/
gpt_pwmcnt		equ		gptbase+$28				/* GPT PWM Count					*/
gpt_pwmabuf		equ		gptbase+$2a				/* GPT PWMA Buffer					*/
gpt_pwmbbuf		equ		gptbase+$2b				/* GPT PWMB Buffer					*/
gpt_prescl		equ		gptbase+$2c				/* GPT Prescaler					*/

/************************************************************************************/

sim_mcr			equ		simbase					/* Module Configuration				*/
sim_simtr		equ		simbase+$02				/* Module Test						*/
sim_syncr		equ		simbase+$04				/* Clock Synthesizer Control		*/
sim_rsr			equ		simbase+$07				/* Reset Status Register			*/
sim_simtre		equ		simbase+$08				/* Module Test E					*/
sim_porte		equ		simbase+$13				/* Port E Data						*/
sim_ddre		equ		simbase+$15				/* Port E Data Direction			*/
sim_pepar		equ		simbase+$17				/* Port E Pin Assignment			*/
sim_portf		equ		simbase+$1b				/* Port F Data						*/
sim_ddrf		equ		simbase+$1d				/* Port F Data Direction			*/
sim_pfpar		equ		simbase+$1f				/* Port F Pin Assignment			*/
sim_sypcr		equ		simbase+$21				/* System Protection Control		*/
sim_picr		equ		simbase+$22				/* Periodic Interrupt Control		*/
sim_pitr		equ		simbase+$24				/* Periodic Interrupt Timing		*/
sim_swsr		equ		simbase+$27				/* Software Service					*/
sim_tstmsra		equ		simbase+$30				/* Test Module Master Shift A		*/
sim_tstmsrb		equ		simbase+$32				/* Test Module Master Shift B		*/
sim_tstsca		equ		simbase+$34				/* Test Module Shift Count A		*/
sim_tstscb		equ		simbase+$35				/* Test Module Shift Count B		*/
sim_tstrc		equ		simbase+$36				/* Test Module Repetition Count		*/
sim_creg		equ		simbase+$38				/* Test Module Control Register		*/
sim_dreg		equ		simbase+$3a				/* Test Module Distributed Register	*/
sim_cspdr		equ		simbase+$41				/* Port C Data						*/
sim_cspar0		equ		simbase+$44				/* Chip Select Pin Assignment 0		*/
sim_cspar1		equ		simbase+$46				/* Chip Select Pin Assignment 1		*/
sim_csbarbt		equ		simbase+$48				/* Chip Select Base Boot			*/
sim_csorbt		equ		simbase+$4a				/* Chip Select Option Boot			*/
sim_csbar0		equ		simbase+$4c				/* Chip Select Base 0				*/
sim_csor0		equ		simbase+$4e				/* Chip Select Option 0				*/
sim_csbar1		equ		simbase+$50				/* Chip Select Base 1				*/
sim_csor1		equ		simbase+$52				/* Chip Select Option 1				*/
sim_csbar2		equ		simbase+$54				/* Chip Select Base 2				*/
sim_csor2		equ		simbase+$56				/* Chip Select Option 2				*/
sim_csbar3		equ		simbase+$58				/* Chip Select Base 3				*/
sim_csor3		equ		simbase+$5a				/* Chip Select Option 3				*/
sim_csbar4		equ		simbase+$5c				/* Chip Select Base 4				*/
sim_csor4		equ		simbase+$5e				/* Chip Select Option 4				*/
sim_csbar5		equ		simbase+$60				/* Chip Select Base 5				*/
sim_csor5		equ		simbase+$62				/* Chip Select Option 5				*/
sim_csbar6		equ		simbase+$64				/* Chip Select Base 6				*/
sim_csor6		equ		simbase+$66				/* Chip Select Option 6				*/
sim_csbar7		equ		simbase+$68				/* Chip Select Base 7				*/
sim_csor7		equ		simbase+$6a				/* Chip Select Option 7				*/
sim_csbar8		equ		simbase+$6c				/* Chip Select Base 8				*/
sim_csor8		equ		simbase+$6e				/* Chip Select Option 8				*/
sim_csbar9		equ		simbase+$70				/* Chip Select Base 9				*/
sim_csor9		equ		simbase+$72				/* Chip Select Option 9				*/
sim_csbar10		equ		simbase+$74				/* Chip Select Base 10				*/
sim_csor10		equ		simbase+$76				/* Chip Select Option 10			*/

/************************************************************************************/

ram_mcr			equ		ramctrlbase				/* RAM Configuration				*/
ram_tst			equ		ramctrlbase+$02			/* RAM Test							*/
ram_bar			equ		ramctrlbase+$04			/* RAM Base Address/Status			*/

/************************************************************************************/

qsm_qmcr		equ		qsmbase					/* QSM Module Configuration			*/
qsm_qtest		equ		qsmbase+$02				/* QSM Test							*/
qsm_qilr		equ		qsmbase+$04				/* QSM Interrupt Level				*/
qsm_qivr		equ		qsmbase+$05				/* QSM Interrupt Vector				*/
qsm_sccr0		equ		qsmbase+$08				/* SCI Control 0					*/
qsm_sccr1		equ		qsmbase+$0a				/* SCI Control 1					*/
qsm_scsr		equ		qsmbase+$0c				/* SCI Status						*/
qsm_scdr		equ		qsmbase+$0e				/* SCI Data							*/
qsm_qpdr		equ		qsmbase+$15				/* QSM Port Data					*/
qsm_qpar		equ		qsmbase+$16				/* QSM Pin Assignment				*/
qsm_qddr		equ		qsmbase+$17				/* QSM Data Direction				*/
qsm_spcr0		equ		qsmbase+$18				/* QSPI Control 0					*/
qsm_spcr1		equ		qsmbase+$1a				/* QSPI Control 1					*/
qsm_spcr2		equ		qsmbase+$1c				/* QSPI Control 2					*/
qsm_spcr3		equ		qsmbase+$1e				/* QSPI Control 3					*/
qsm_spsr		equ		qsmbase+$1f				/* QSPI Status						*/

qsm_rec			equ		qsmbase+$100			/* QSPI Receive RAM					*/
qsm_tran		equ		qsmbase+$120			/* QSPI Transfer RAM				*/
qsm_comd		equ		qsmbase+$140			/* QSPI Command RAM					*/

/************************************************************************************/

tpu_mcr			equ		tpubase					/* TPU Module Configuration			*/
tpu_cr			equ		tpubase+$02				/* TPU Configuration				*/
tpu_dscr		equ		tpubase+$04				/* TPU Developement Support Control	*/
tpu_dssr		equ		tpubase+$06				/* TPU Developement Support Status	*/
tpu_icr			equ		tpubase+$08				/* TPU Interrupt Configuration		*/
tpu_ier			equ		tpubase+$0a				/* TPU Interrupt Enable				*/
tpu_cfsr0		equ		tpubase+$0c				/* TPU Channel Function	Select 0	*/
tpu_cfsr1		equ		tpubase+$0e				/* TPU Channel Function	Select 1	*/
tpu_cfsr2		equ		tpubase+$10				/* TPU Channel Function	Select 2	*/
tpu_cfsr3		equ		tpubase+$12				/* TPU Channel Function	Select 3	*/
tpu_hsr0		equ		tpubase+$14				/* TPU Host Sequence 0				*/
tpu_hsr1		equ		tpubase+$16				/* TPU Host Sequence 1				*/
tpu_hsrr0		equ		tpubase+$18				/* TPU Host Service Request 0		*/
tpu_hsrr1		equ		tpubase+$1a				/* TPU Host Service Request 1		*/
tpu_cpr0		equ		tpubase+$1c				/* TPU Channel Priority 0			*/
tpu_cpr1		equ		tpubase+$1e				/* TPU Channel Priority 1			*/
tpu_isr			equ		tpubase+$20				/* TPU Interrupt Status				*/
tpu_lr			equ		tpubase+$22				/* TPU Link							*/
tpu_sglr		equ		tpubase+$24				/* TPU Service Grant Latch			*/
tpu_dcnr		equ		tpubase+$26				/* TPU Decoded Channel Number		*/

/************************************************************************************/
