/*************************************************************************************
**																					**
**				cogito Gesellschaft fr Elektronikentwicklung mbH					**
**	  																				**
**						Pure C Startup Code for MC68XXX Single-Board-Computer		**
**																					**
**							File			: MC68XXXS.S							**
**							Author			: Frank Sautter							**
**							First Byte		: 14.07.93								**
**							Latest Change	: 18.11.94								**
**																					**
**																					**		
*************************************************************************************/

			include		"MC683XX.sh"
			include		"start_s.sh"

			offset 0
			text
		
/************************************************************************************
 *	256 Systemvektoren																*
 ************************************************************************************/

Start:
.if KERNEL=1
			bra.w		init_331			; 0 Zum Initstart springen
			dc.l		init_331-Start		; 1 Programm Counter after Reset
			dc.l		notinst				; 2 Bus Error
			dc.l		notinst				; 3 Adress Error
			dc.l		ill_instr			; 4 Illegal Instruction
			dc.l		notinst				; 5 Zero Divide not installed
			dc.l		notinst				; 6 CHK Instruction not installed
			dc.l		notinst				; 7 TRAPV Instruction
			dc.l		notinst				; 8 Priveledge Voilation not installed
			dc.l		notinst				; 9 Trace
			dc.l		notinst				;10 Line A Emulator
			dc.l		notinst				;11 Line F Emulator
			dc.l		notinst				;12 reserved
			dc.l		notinst				;13 reserved
			dc.l		notinst				;14 Format Error not installed
			dc.l		notinst				;15 Uninitialized Interrupt not installed

			dc.l		notinst				;16 reserved
			dc.l		notinst				;17 reserved
			dc.l		notinst				;18 reserved
			dc.l		notinst				;19 reserved
			dc.l		notinst				;20 reserved
			dc.l		notinst				;21 reserved
			dc.l		notinst				;22 reserved
			dc.l		notinst				;23 reserved
			dc.l		notinst				;24 Superious Interrupt
			dc.l		notinst				;25 Level 1 Interrupt Autovector
			dc.l		notinst				;26 Level 2 Interrupt Autovector
			dc.l		notinst				;27 Level 3 Interrupt Autovector
			dc.l		notinst				;28 Level 4 Interrupt Autovector
			dc.l		notinst				;29 Level 5 Interrupt Autovector
			dc.l		notinst				;30 Level 6 Interrupt Autovector
			dc.l		notinst				;31 Level 7 Interrupt Autovector

			dc.l		notinst				;32 TRAP #0
			dc.l		notinst				;33 TRAP #1
			dc.l		notinst				;34 TRAP #2
			dc.l		notinst				;35 TRAP #3
			dc.l		notinst				;36 TRAP #4
			dc.l		notinst				;37 TRAP #5
			dc.l		notinst				;38 TRAP #6
			dc.l		notinst				;39 TRAP #7
			dc.l		notinst				;40 TRAP #8
			dc.l		notinst				;41 TRAP #9
			dc.l		notinst				;42 TRAP #10
			dc.l		notinst				;43 TRAP #11
			dc.l		notinst				;44 TRAP #12
			dc.l		notinst				;45 TRAP #13
			dc.l		notinst				;46 TRAP #14
			dc.l		notinst				;47 TRAP #15

			dc.l		notinst				;48 reserved
			dc.l		notinst				;49 reserved
			dc.l		notinst				;50 reserved
			dc.l		notinst				;51 reserved
			dc.l		notinst				;52 reserved
			dc.l		notinst				;53 reserved
			dc.l		notinst				;54 reserved
			dc.l		notinst				;55 reserved
			dc.l		notinst				;56 reserved
			dc.l		notinst				;57 reserved
			dc.l		notinst				;58 reserved
			dc.l		notinst				;59 reserved
			dc.l		notinst				;60 reserved
			dc.l		notinst				;61 reserved
			dc.l		notinst				;62 reserved
			dc.l		notinst				;63 reserved

			dc.l		systimer			;64 User Defined 100Hz Systemtimer
			dc.l		notinst				;65 User Defined
			dc.l		notinst				;66 User Defined
			dc.l		notinst				;67 User Defined
			dc.l		notinst				;68 User Defined
			dc.l		notinst				;69 User Defined
			dc.l		notinst				;70 User Defined
			dc.l		notinst				;71 User Defined
			dc.l		notinst				;72 User Defined
			dc.l		notinst				;73 User Defined
			dc.l		notinst				;74 User Defined
			dc.l		notinst				;75 User Defined
			dc.l		notinst				;76 User Defined
			dc.l		notinst				;77 User Defined
			dc.l		notinst				;78 User Defined
			dc.l		notinst				;79 User Defined

			dc.l		notinst				;80 User Defined
			dc.l		notinst				;81 User Defined
			dc.l		notinst				;82 User Defined
			dc.l		notinst				;83 User Defined
			dc.l		notinst				;84 User Defined
			dc.l		notinst				;85 User Defined
			dc.l		notinst				;86 User Defined
			dc.l		notinst				;87 User Defined
			dc.l		notinst				;88 User Defined
			dc.l		notinst				;89 User Defined
			dc.l		notinst				;90 User Defined
			dc.l		notinst				;91 User Defined
			dc.l		notinst				;92 User Defined
			dc.l		notinst				;93 User Defined
			dc.l		notinst				;94 User Defined
			dc.l		notinst				;95 User Defined

			dc.l		notinst				;96 User Defined
			dc.l		notinst				;97 User Defined
			dc.l		notinst				;98 User Defined
			dc.l		notinst				;99 User Defined
			dc.l		notinst				;100 User Defined
			dc.l		notinst				;101 User Defined
			dc.l		notinst				;102 User Defined
			dc.l		notinst				;103 User Defined
			dc.l		notinst				;104 User Defined
			dc.l		notinst				;105 User Defined
			dc.l		notinst				;106 User Defined
			dc.l		notinst				;107 User Defined
			dc.l		notinst				;108 User Defined
			dc.l		notinst				;109 User Defined
			dc.l		notinst				;110 User Defined
			dc.l		notinst				;111 User Defined

			dc.l		notinst				;112 User Defined
			dc.l		notinst				;113 User Defined
			dc.l		notinst				;114 User Defined
			dc.l		notinst				;115 User Defined
			dc.l		notinst				;116 User Defined
			dc.l		notinst				;117 User Defined
			dc.l		notinst				;118 User Defined
			dc.l		notinst				;119 User Defined
			dc.l		notinst				;120 User Defined
			dc.l		notinst				;121 User Defined
			dc.l		notinst				;122 User Defined
			dc.l		notinst				;123 User Defined
			dc.l		notinst				;124 User Defined
			dc.l		notinst				;125 User Defined
			dc.l		notinst				;126 User Defined
			dc.l		notinst				;127 User Defined

			dc.l		notinst				;128 User Defined
			dc.l		notinst				;129 User Defined
			dc.l		notinst				;130 User Defined
			dc.l		notinst				;131 User Defined
			dc.l		notinst				;132 User Defined
			dc.l		notinst				;133 User Defined
			dc.l		notinst				;134 User Defined
			dc.l		notinst				;135 User Defined
			dc.l		notinst				;136 User Defined
			dc.l		notinst				;137 User Defined
			dc.l		notinst				;138 User Defined
			dc.l		notinst				;139 User Defined
			dc.l		notinst				;140 User Defined
			dc.l		notinst				;141 User Defined
			dc.l		notinst				;142 User Defined
			dc.l		notinst				;143 User Defined

			dc.l		notinst				;144 User Defined
			dc.l		notinst				;145 User Defined
			dc.l		notinst				;146 User Defined
			dc.l		notinst				;147 User Defined
			dc.l		notinst				;148 User Defined
			dc.l		notinst				;149 User Defined
			dc.l		notinst				;150 User Defined
			dc.l		notinst				;151 User Defined
			dc.l		notinst				;152 User Defined
			dc.l		notinst				;153 User Defined
			dc.l		notinst				;154 User Defined
			dc.l		notinst				;155 User Defined
			dc.l		notinst				;156 User Defined
			dc.l		notinst				;157 User Defined
			dc.l		notinst				;158 User Defined
			dc.l		notinst				;159 User Defined

			dc.l		notinst				;160 User Defined
			dc.l		notinst				;161 User Defined
			dc.l		notinst				;162 User Defined
			dc.l		notinst				;163 User Defined
			dc.l		notinst				;164 User Defined
			dc.l		notinst				;165 User Defined
			dc.l		notinst				;166 User Defined
			dc.l		notinst				;167 User Defined
			dc.l		notinst				;168 User Defined
			dc.l		notinst				;169 User Defined
			dc.l		notinst				;170 User Defined
			dc.l		notinst				;171 User Defined
			dc.l		notinst				;172 User Defined
			dc.l		notinst				;173 User Defined
			dc.l		notinst				;174 User Defined
			dc.l		notinst				;175 User Defined

			dc.l		notinst				;176 User Defined
			dc.l		notinst				;177 User Defined
			dc.l		notinst				;178 User Defined
			dc.l		notinst				;179 User Defined
			dc.l		notinst				;180 User Defined
			dc.l		notinst				;181 User Defined
			dc.l		notinst				;182 User Defined
			dc.l		notinst				;183 User Defined
			dc.l		notinst				;184 User Defined
			dc.l		notinst				;185 User Defined
			dc.l		notinst				;186 User Defined
			dc.l		notinst				;187 User Defined
			dc.l		notinst				;188 User Defined
			dc.l		notinst				;189 User Defined
			dc.l		notinst				;190 User Defined
			dc.l		notinst				;191 User Defined

			dc.l		notinst				;192 User Defined
			dc.l		notinst				;193 User Defined
			dc.l		notinst				;194 User Defined
			dc.l		notinst				;195 User Defined
			dc.l		notinst				;196 User Defined
			dc.l		notinst				;197 User Defined
			dc.l		notinst				;198 User Defined
			dc.l		notinst				;199 User Defined
			dc.l		notinst				;200 User Defined
			dc.l		notinst				;201 User Defined
			dc.l		notinst				;202 User Defined
			dc.l		notinst				;203 User Defined
			dc.l		notinst				;204 User Defined
			dc.l		notinst				;205 User Defined
			dc.l		notinst				;206 User Defined
			dc.l		notinst				;207 User Defined

			dc.l		notinst				;208 User Defined
			dc.l		notinst				;209 User Defined
			dc.l		notinst				;210 User Defined
			dc.l		notinst				;211 User Defined
			dc.l		notinst				;212 User Defined
			dc.l		notinst				;213 User Defined
			dc.l		notinst				;214 User Defined
			dc.l		notinst				;215 User Defined
			dc.l		notinst				;216 User Defined
			dc.l		notinst				;217 User Defined
			dc.l		notinst				;218 User Defined
			dc.l		notinst				;219 User Defined
			dc.l		notinst				;220 User Defined
			dc.l		notinst				;221 User Defined
			dc.l		notinst				;222 User Defined
			dc.l		notinst				;223 User Defined

			dc.l		notinst				;224 User Defined
			dc.l		notinst				;225 User Defined
			dc.l		notinst				;226 User Defined
			dc.l		notinst				;227 User Defined
			dc.l		notinst				;228 User Defined
			dc.l		notinst				;229 User Defined
			dc.l		notinst				;230 User Defined
			dc.l		notinst				;231 User Defined
			dc.l		notinst				;232 User Defined
			dc.l		notinst				;233 User Defined
			dc.l		notinst				;234 User Defined
			dc.l		notinst				;235 User Defined
			dc.l		notinst				;236 User Defined
			dc.l		notinst				;237 User Defined
			dc.l		notinst				;238 User Defined
			dc.l		notinst				;239 User Defined

			dc.l		notinst				;240 User Defined
			dc.l		notinst				;241 User Defined
			dc.l		notinst				;242 User Defined
			dc.l		notinst				;243 User Defined
			dc.l		notinst				;244 User Defined
			dc.l		notinst				;245 User Defined
			dc.l		notinst				;246 User Defined
			dc.l		notinst				;247 User Defined
			dc.l		notinst				;248 User Defined
			dc.l		notinst				;249 User Defined
			dc.l		notinst				;250 User Defined
			dc.l		notinst				;251 User Defined
			dc.l		notinst				;252 User Defined
			dc.l		notinst				;253 User Defined
			dc.l		notinst				;254 User Defined
			dc.l		notinst				;255 User Defined


/************************************************************************************
 *	Code for return on non initialized exeptions									*
 ************************************************************************************/

notinst:	rte								; Return from not installed vectors


/************************************************************************************
 *	Code for illegal exeption processing											*
 ************************************************************************************/

ill_instr:	add.l		#2,2(sp)			; Increase PC
			rte	


/************************************************************************************
 *	Hier beginnt der eigentliche Code												*
 ************************************************************************************/

init_331:	lea.l		_Bsstop+$400,a0
			move.l		a0,sp
			move.l		a0,usp

			move.w		#%1110000001001111,sim_mcr		;Set mcr
			move.b		#%00000100,sim_sypcr			;No Watchdog
.endif
			move.w		#$7f00,sim_syncr				;Set CPU to 16MHz

.if KERNEL==1
			btst.b		#0,sim_cspar0					;check if bootrom is 8bit or 16bit wide
			bne.s		.bra_01
.if RAMCONFIG==8
			move.w		#%0110100000110000,sim_csorbt	;rom is readonly, no waitstates 
			move.w		sim_cspar0,d0
			and.w		#%1111111111110011,d0
			or.w		#%0000000000001000,d0			;init /cs0 as 8bit port
			move.w		d0,sim_cspar0
			move.w		#$1007,sim_csbar7				;/cs0 with 1M blocksize, base $100000
			move.w		#%0111001110110000,sim_csor0	;SIM-CSOR0 Write only
.else
.if ROMRAMCONFIG==816
			move.w		#%0000101010111110,sim_cspar0	;SIM-CSPAR0
			move.w		#%0000000000000001,sim_cspar1	;SIM-CSPAR1 /CS6=A19
			move.w		#$0006,sim_csbarbt				;SIM-CSARBT 512k-Blocksize ROM Base $000
			move.w		#%0110100000110000,sim_csorbt	;SIM-CSORBT Read Only
			move.w		#$0007,sim_csbar0				;SIM-CSBAR0 1M-Blocksize RAM Base $000
			move.w		#%0011000000110000,sim_csor0	;SIM-CSOR0 Lower Byte Write only
			move.w		#$0007,sim_csbar1				;SIM-CSBAR1 1M-Blocksize RAM Base $000
			move.w		#%0101000000110000,sim_csor1	;SIM-CSOR1 Upper Byte Write only
.endif

.if ROMRAMCONFIG==1616
			move.w		#%0010101010111111,sim_cspar0	;SIM-CSPAR0
			move.w		#%0000001010101001,sim_cspar1	;SIM-CSPAR1 /CS6=A19
			move.w		#$0007,sim_csbarbt				;SIM-CSARBT 1M-Blocksize ROM Base $000
			move.w		#%0110100000110000,sim_csorbt	;SIM-CSORBT Read Only
			move.w		#$0007,sim_csbar0				;SIM-CSBAR0 1M-Blocksize RAM Base $000
			move.w		#%0011000000110000,sim_csor0	;SIM-CSOR0 Lower Byte Write only
			move.w		#$0007,sim_csbar1				;SIM-CSBAR1 1M-Blocksize RAM Base $000
			move.w		#%0101000000110000,sim_csor1	;SIM-CSOR1 Upper Byte Write only
.endif

			lea			Start,a0						;Ist Code fr Adresse 0 compiliert, 
			lea			_Prgtop,a1
			tst.l		a0								;dann ROM ins RAM kopieren
			beq.s		remap							;Ansonnsten ROM ummappen

			lea			remapped-Start,a1

remap:		lea			$0,a0							;ROM ins RAM kopieren
.copyloop:	move.w		(a0),(a0)+
			cmp.l		a0,a1
			bne.s		.copyloop
			
.if ROMRAMCONFIG==88
			move.w		#%0111100000110000,sim_csor0	;SIM-CSOR0 R/W
			move.w		#$c006,sim_csbarbt				;SIM-CSARBT 512k-Blocksize ROM Base $c00
.endif

.if ROMRAMCONFIG==816
			move.w		#%0011100000110000,sim_csor0	;SIM-CSOR0 Lower Byte R/W
			move.w		#%0101100000110000,sim_csor1	;SIM-CSOR1 Upper Byte R/W
			move.w		#$c006,sim_csbarbt				;SIM-CSARBT 512k-Blocksize ROM Base $c00
.endif

.if ROMRAMCONFIG==1616
			move.w		#%0011100000110000,sim_csor0	;SIM-CSOR0 Lower Byte R/W
			move.w		#%0101100000110000,sim_csor1	;SIM-CSOR1 Upper Byte R/W
			move.w		#$c007,sim_csbarbt				;SIM-CSARBT 1M-Blocksize ROM Base $c00
.endif

			jmp			remapped						;Umschalten und Sprung
			nop

remapped:	dc.w		bgnd							;stop for background mode debugger

.endif
			move.b		#$00,sim_pfpar
			move.l		#_Bsstop+$400,rambot			;Set rambot
			move.l		#$040000,ramtop					;Set ramtop
			;Hier mu endlich ein RAMtest her

			move.l		#16777000,cpuspeed				;16MHz CPU clock

.if KERNEL==1 
			move.w		#$0052,sim_pitr					;100Hz periodic timer
			move.w		#$0240,sim_picr					;Vector 64
			lea			$000000,a0						;System Vektors are now in RAM area
			movec.l		a0,vbr
			
			btst.b		#6,sim_rsr						;Last Reset was Power Up
			beq.s		.nopowup
			move.l		#0,sysclock						;initialize systemtimer
.nopowup:

.if MC68XXX==331
			move.w		#$0000,gpt_tmsk1				;Normal Function no interrupts
			move.w		#$0000,gpt_oc1m					;GPIO Function
			move.b		#%00000011,gpt_pddr
			move.b		#%00000001,gpt_pdr
.endif

			move.w		#$2100,sr						;Enabling Interrupts
		
			cmp.l		#$04111967,automagic
			bne			.noauto
			move.w		#600,d0
			move.w		#100,d1
			bsr			beep
			move.l		autoadress,a0
			jsr			(a0)
.endif

.noauto:
        	jsr			main

__Exit:		movec.l		vbr,a0							;Get Vector Base Register
			move.l		4(a0),a0						;Get Reset Vektor
			jmp			(a0)							;And go.....
			

/************************************************************************************
 *	Autostart setzen																*
 ************************************************************************************/

set_auto:	move.l		a0,autoadress					;Adresse speichern
			move.l		#$04111967,automagic			;Magic setzen
			rts

/************************************************************************************
 *	Autostart lschen																*
 ************************************************************************************/

kill_auto:	clr.l		automagic						;Magic lschen
			rts

/************************************************************************************
 *	Programm starten																*
 ************************************************************************************/

prgstart:	jmp			(a0)

/************************************************************************************
 *	Ein bischen piepsen																*
 ************************************************************************************/

beep:
			ext.l		d1
			divu		#10,d1
			ext.l		d1
			add.l		sysclock,d1

			tst.l		d0
			beq			.branch2
			move.l		cpuspeed,d2
			mulu		#10,d0
			divu		d0,d2
			bvs			.branch2
			ext.l		d2
			subq.l		#4,d2
			tst.l		d2
			bpl			.branch1
			moveq.l		#0,d2

.if MC68XXX==331 
.branch1:	or.b        #$03,gpt_pddr
			bset.b		#0,gpt_pdr
			bclr.b		#1,gpt_pdr

.loop1:		eor.b		#$03,gpt_pdr
			move.w		d2,d0
.loop2:		dbra		d0,.loop2
			cmp.l		sysclock,d1
			bpl			.loop1
.endif

.if MC68XXX==332 
.branch1:	move.w		tpu_cfsr3,d0
			and.w		#$f00f,d0
			and.w		#$0880,d0
			move.w		d0,tpu_cfsr3
			or.w		#$003c,tpu_cpr1
			
.loop1:		bset.b		#2,tpu_hsrr1+1
			bset.b		#5,tpu_hsrr1+1		
			move.w		d2,d0
.loop2:		dbra		d0,.loop2
			nop
			nop
			nop
			bset.b		#3,tpu_hsrr1+1
			bset.b		#4,tpu_hsrr1+1		
			move.w		d2,d0
.loop3:		dbra		d0,.loop3
			cmp.l		sysclock,d1
			bpl			.loop1
			rts
.endif
			
.branch2:	cmp.l		sysclock,d1
			bpl			.branch2
			rts

/************************************************************************************
 *	Watchdog bedienen																*
 ************************************************************************************/

watchdog:	move.b		#$55,sim_swsr
			move.b		#$aa,sim_swsr
			rts

/************************************************************************************
 *	1/100 sec Timer Interrupt														*
 ************************************************************************************/

systimer:	addq.l		#1,sysclock			;increment systemtimer
			rte

/************************************************************************************
 *	BSS segement																	*
 ************************************************************************************/

			bss
			
sysclock:	ds.l		1
rambot:		ds.l		1
ramtop:		ds.l		1
cpuspeed:	ds.l		1
autoadress:	ds.l		1
automagic:	ds.l		1
transstart:	ds.l		1
warmmagic:	ds.l		1

        	end

/************************************************************************************/


