/*************************************************************************************
**																					**
**				cogito Gesellschaft fr Elektronikentwicklung mbH					**
**	  																				**
**						Serial routines for MC683XX QSM								**
**																					**
**							File			: QSMSER_S.S							**
**							Author			: Frank Sautter							**
**							Version			: 1.00									**
**							First Byte		: 24.12.93								**
**							Latest Change	: 28.01.94								**
**																					**
**																					**		
*************************************************************************************/

			include		"mc683xx.sh"
			include		"start_s.sh"
		
			bufsize		equ	256
			
			export		ser_init
			export		ser_out
			export		ser_stat
			export		ser_in

/************************************************************************************
 *	Initializing Serial Interface													*
 ************************************************************************************/

ser_init:	mulu.w		#32,d0
			move.l		cpuspeed,d1
			divu.l		d0,d1
			
			move.l		#in_buf,in_bufptr
			move.w		#bufsize,in_size
			move.w		#0,in_head
			move.w		#0,in_tail
			move.w		#bufsize/4,in_low
			move.w		#bufsize*3/4,in_high
			move.w		#0,in_status
			move.w		#0,in_timeout
			
			move.l		#out_buf,out_bufptr
			move.w		#bufsize,out_size
			move.w		#0,out_head
			move.w		#0,out_tail
			move.w		#bufsize/4,out_low
			move.w		#bufsize*3/4,out_high
			move.w		#0,out_status
			move.w		#0,out_timeout
			
			bclr.b		#5,qsm_qpar						;PCS2 as GPIO (CTS)
			bclr.b		#6,qsm_qpar						;PCS3 as GPIO (RTS)
			bclr.b		#5,qsm_qddr						;PCS2 as Input (CTS)
			bset.b		#6,qsm_qddr						;PCS3 as Output (RTS)
			bclr.b		#6,qsm_qpdr						;RTS low (enable flow)
			
			move.w		#$000f,qsm_qmcr					;QSM Configuration Register
			move.b		#%00000110,qsm_qilr				;Interrupt levels
			move.b		#66,qsm_qivr					;Vector 65

			movec.l		vbr,a0							;Get Vector Base Register
			move.l		#ser_int,4*66(a0)				;Set Interrupt Vektor
			move.l		#ser_timer,4*64(a0)

			move.w		d1,qsm_sccr0					;Set Baud Rate
			move.w		#%0000000010101100,qsm_sccr1	;Enable Receiver/Transmitter
			rts

/************************************************************************************
 *	Sending Serial Data																*
 ************************************************************************************/

ser_out:	move.l		out_bufptr,a0					;zeiger auf buffer
.b_01:		move.w		out_head,d1						;index auf head
			sub.w		out_tail,d1						;mit index auf tail vergleichen
			bpl			.b_02							;schon positiv
			add.w		out_size,d1						;positiv machen
.b_02:		addq.w		#2,d1							;plus 2
			cmp.w		out_size,d1						;puffergre erreicht ?
 			beq			.b_01							;puffer voll
				
			move.w		out_head,d1						;index auf head
			move.b		d0,0(a0,d1.w)					;byte in puffer schreiben
			addq.w		#1,d1							;tail index erhhen
			cmp.w		out_size,d1						;wrap around ?
			bmi			.b_03							;n
			moveq.l		#0,d1							;index auf anfang
.b_03:		move.w		d1,out_head						;index abspeichern

			btst.b		#5,qsm_qpdr+1					;Test CTS
			bne.s		.b_04							;CTS high
			bset.b		#7,qsm_sccr1+1					;Enable transmitter interrupt
		
.b_04:		rts

/************************************************************************************
 *	Check Serial Status																*
 ************************************************************************************/

ser_stat:	move.w		in_tail,d0						;When head==tail then there's
			cmp.w		in_head,d0						;no character in the buffer
			bne			.b_01
			moveq.l		#0,d0							;Buffer empty
			rts
.b_01:		moveq.l		#1,d0							;Character available
			rts
			
/************************************************************************************
 *	Reading data out of serial input buffer											*
 ************************************************************************************/

ser_in:		move.l		in_bufptr,a0					;zeiger auf buffer
.b_01:		move.w		in_tail,d1						;index auf tail
			cmp.w		in_head,d1						;index auf head
			beq			.b_01							;kein zeichen im puffer vorhanden
							
			move.w		sr,d2							;save interruptlevel
			or.w		#$0700,sr						;disable interrupts
			
			move.b		0(a0,d1.w),d0					;byte aus puffer holen
			addq.w		#1,d1							;tail index erhhen
			cmp.w		in_size,d1						;wrap around ?
			bmi			.b_02							;n
			moveq.l		#0,d1							;index auf anfang
			
.b_02:		move.w		d1,in_tail						;index abspeichern
			move.w		in_head,d1						;index auf head holen
			sub.w		in_tail,d1						;head-tail
			bpl			.b_03							;schon positiv
			add.w		in_size,d1						;positiv machen
.b_03:		cmp.w		in_low,d1						;low water mark erreicht ?
			bpl			.b_05							;nein

.b_04:		bclr.b		#6,qsm_qpdr						;RTS low (enable flow)
				
.b_05:		move.w		d2,sr							;restore interrruptlevel
			rts


/************************************************************************************
 *	1/100 sec Timer Interrupt														*
 ************************************************************************************/

ser_timer:	addq.l		#1,sysclock						;Increment systemtimer
			btst.b		#5,qsm_qpdr+1					;Test CTS
			beq.s		.b_01							;CTS low

			tst.w		cts_sem
			beq.s		.b_02
			move.w		#0,cts_sem
			bclr.b		#7,qsm_sccr1+1					;Disable transmitter interrupt
			rte
			
.b_01:		tst.w		cts_sem
			bne.s		.b_02
			move.w		#1,cts_sem
			bset.b		#7,qsm_sccr1+1					;Enable transmitter interrupt
.b_02:		rte

/************************************************************************************
 *	Serial interrupthandler															*
 ************************************************************************************/

ser_int:	movem.l		d0-d1/a0,-(sp)					;save register

			move.w		qsm_scsr,scsr_dup

			btst		#6,scsr_dup+1					;receiver ready
			beq			.b_01							;not the reason
			bsr			ser_int_i
				
.b_01:		btst		#0,scsr_dup						;transmitter ready
			beq			.b_02							;not me
			bsr			ser_int_o

.b_02:		movem.l		(sp)+,d0-d1/a0					;restore register
			rte


/************************************************************************************
 *	Serial receiver interrupt														*
 ************************************************************************************/

ser_int_i:	move.b		qsm_scdr+1,d1					;byte aus fifo

.b_01:		move.w		in_head,d0						;index auf head
			sub.w		in_tail,d0						;mit index auf tail vergleichen
			bpl			.b_02							;schon positiv
			add.w		in_size,d0						;positiv machen
.b_02:		addq.w		#2,d0							;plus 2
			cmp.w		in_size,d0						;puffergre erreicht ?
 			beq			.b_07							;puffer voll

			move.l		in_bufptr,a0					;zeiger auf buffer
			move.w		in_head,d0						;index auf head
			move.b		d1,0(a0,d0.w)					;byte aus fifo in puffer
			addq.w		#1,d0							;head index erhhen
			cmp.w		in_size,d0						;wrap around ?
			bmi			.b_03							;n
			moveq.l		#0,d0							;index zurcksetzen
.b_03:		move.w		d0,in_head						;head index zurckschreiben
			sub.w		in_tail,d0						;head-tail
			bpl			.b_04							;schon positiv
			add.w		in_size,d0						;positiv machen
.b_04:		cmp.w		in_high,d0						;high water mark erreicht ?
			bmi			.b_06							;nein
				
.b_05:		bset.b		#6,qsm_qpdr						;RTS high (disable flow)
				
.b_06:		rts
				
.b_07:		move.w		#-1,in_status		;Error
			rts
			
/************************************************************************************
 *	Serial transmitter interrupt													*
 ************************************************************************************/

ser_int_o:	btst.b		#5,qsm_qpdr+1					;Test CTS
			bne.s		.b_02							;CTS high
		
			move.l		out_bufptr,a0					;pointer on buffer
			move.w		out_tail,d0						;index on tail
			cmp.w		out_head,d0						;index on head
			beq.s		.b_02							;character available
			
			move.b		0(a0,d0.w),qsm_scdr+1			;get byte from buffer
			addq.w		#1,d0							;increment tail index
			cmp.w		out_size,d0						;wrap around ?
			bmi			.b_01							;no
			moveq.l		#0,d0							;index to begin
.b_01:		move.w		d0,out_tail						;save index
			rts

.b_02:		bclr.b		#7,qsm_sccr1+1					;Disable transmitter interrupt
			rts
								
/************************************************************************************
 *	Block storage segment															*
 ************************************************************************************/

			.bss
			
scsr_dup:	ds.w		1
cts_sem:	ds.w		1

in_bufptr:	ds.l		1
in_size:	ds.w		1
in_head:	ds.w		1
in_tail:	ds.w		1
in_low:		ds.w		1
in_high:	ds.w		1
in_status:	ds.w		1
in_timeout:	ds.w		1

in_buf:		ds.b		bufsize


out_bufptr:	ds.l		1
out_size:	ds.w		1
out_head:	ds.w		1
out_tail:	ds.w		1
out_low:	ds.w		1
out_high:	ds.w		1
out_status:	ds.w		1
out_timeout:ds.w		1

out_buf:	ds.b		bufsize

/************************************************************************************/