/*************************************************************************************
**																					**
**				cogito Gesellschaft fr Elektronikentwicklung mbH					**
**	  																				**
**						Pure C Startup Code for MC68XXX Single-Board-Computer		**
**																					**
**							File			: START_S.S								**
**							Author			: Frank Sautter							**
**							Version			: 1.00									**
**							First Byte		: 28.12.93								**
**							Latest Change	: 08.05.94								**
**																					**
**																					**		
*************************************************************************************/

			include		"mc683xx.sh"
			include		"start_s.sh"

			
			offset 0
			text
		
Start:		move.w		#$7f00,sim_syncr				;Set CPU to 16MHz
			move.l		#16777000,cpuspeed				;16MHz CPU clock
			move.l		#$1000,transstart
			move.l		#$1000,rambot
			move.l		#$20000,ramtop
			
			movec.l		vbr,a0							;Get Vector Base Register
			move.l		#0,sysclock
			move.l		#systimer,4*64(a0)
 
	    	jsr			main

__Exit:		movec.l		vbr,a0							;Get Vector Base Register
			move.l		4(a0),a0						;Get Reset Vektor
			jmp			(a0)							;And go.....
			

/************************************************************************************
 *	Ein bischen piepsen																*
 ************************************************************************************/

beep:
			ext.l		d1
			divu		#10,d1
			ext.l		d1
			add.l		sysclock,d1

			tst.l		d0
			beq			.branch2
			move.l		cpuspeed,d2
			mulu		#10,d0
			divu		d0,d2
			bvs			.branch2
			ext.l		d2
			subq.l		#4,d2
			tst.l		d2
			bpl			.branch1
			moveq.l		#0,d2

.if MC68XXX==331 
.branch1:	or.b        #$03,gpt_pddr
			bset.b		#0,gpt_pdr
			bclr.b		#1,gpt_pdr

.loop1:		eor.b		#$03,gpt_pdr
			move.w		d2,d0
.loop2:		dbra		d0,.loop2
			cmp.l		sysclock,d1
			bpl			.loop1
.endif

.if MC68XXX==332 
.branch1:	move.w		tpu_cfsr3,d0
			bclr.l		#4,d0
			bclr.l		#5,d0
			bclr.l		#6,d0
			bset.l		#7,d0
			bclr.l		#8,d0
			bclr.l		#9,d0
			bclr.l		#10,d0
			bset.l		#11,d0
			move.w		d0,tpu_cfsr3
			or.w		#$003c,tpu_cpr1
			
.loop1:		bset.b		#2,tpu_hsrr1+1
			bset.b		#5,tpu_hsrr1+1		
			move.w		d2,d0
.loop2:		dbra		d0,.loop2
			nop
			nop
			nop
			bset.b		#3,tpu_hsrr1+1
			bset.b		#4,tpu_hsrr1+1		
			move.w		d2,d0
.loop3:		dbra		d0,.loop3
			cmp.l		sysclock,d1
			bpl			.loop1
			rts
.endif
			
.branch2:	cmp.l		sysclock,d1
			bpl			.branch2
			rts

/************************************************************************************
 *	Watchdog bedienen																*
 ************************************************************************************/

watchdog:	move.b		#$55,sim_swsr
			move.b		#$aa,sim_swsr
			rts

/************************************************************************************
 *	1/100 sec Timer Interrupt														*
 ************************************************************************************/

systimer:	addq.l		#1,sysclock			;increment systemtimer
			rte

/************************************************************************************
 *	BSS segement																	*
 ************************************************************************************/

			bss
			
sysclock:	ds.l		1
cpuspeed:	ds.l		1
transstart:	ds.l		1
warmmagic:	ds.l		1
rambot:		ds.l		1
ramtop:		ds.l		1

        	end
