| for channel5 and channel6
| Program outputs a single period high time in clock ticks
| therefore period in seconds is
|	clockticks / timerfreq
| at 16MHz CPU, TPU TCR1 timerfreq = 4MHz
	
| Program does not check if PPWA_LW overflowed into PPWA_UB
| next version MUST check this before function can detect more than 15.62ms
	
	
	
	.include "tpuregs.i"

AccFlagX:	.DS 4	
AccFlagY:	.DS 4
	
	.globl	accinit
	
accinit:

	move.l	#INTX,	0x154		| store starting address of interrupt
					| routine for channel 5

	move.l	#INTY,  0x158		| store starting address of interrupt
					| routine for channel 6
	
	or.w	#0x0060, cier		| enable interrupts for channel 5,6

	
	or.w	#0x0ff0, cfsr2		| select ppwa function for channel 5,6
		
	and.w	#0xc3ff, hsqr1		| 24-bit high time
	or.w	#0x2800, hsqr1
		
	move.w	#0x0007, ch5par0	| capture tcr1 on rising edge
	move.w	#0x1400, ch5par1	| maxcount - 20 periods
	move.w	#0xff00, ch5par4	| set ACCUM to 0xFF.

	move.w	#0x0007, ch6par0	| capture tcr1 on rising edge
	move.w	#0x1400, ch6par1	| maxcount - 20 periods
	move.w	#0xff00, ch6par4	| set ACCUM to 0xFF.	

	and.w	#0xc3ff, hsrr1		| request service to initialize
	or.w	#0x2800, hsrr1		| channel 5,6
	
	and.w	#0xc3ff, cpr1		| assign middle priority to channel 5
	or.w	#0x2800, cpr1		| and 6
	
			
wait:
	move.w	hsrr1,	d0
	andi.w	#0x3c00, d0
	bne	wait			| wait until initialization complete

	move.l  #0x00000000, AccFlagX
	move.l	#0x00000000, AccFlagY
	rts

INTX:

	andi.w	#0xffdf, cisr		| channel 5 interrupt not asserted
					| (clearing it)

	move.l  #0x00000001, AccFlagX
	and.w	#0xffdf	, cier
	rte

INTY:	

	andi.w	#0xffbf, cisr		| channel 6 interrupt not asserted
					| (clearing it)

	move.l  #0x00000001, AccFlagY
	and.w	#0xffbf	, cier
	rte
	
	.globl	accreadX		
accreadX:  
	cmpi.l  #0x01, AccFlagX
	beq	readokX

	move.l  #0xffffffff, d0
	rts

readokX:	
	clr.l	d0
	move.w	ch5par5, d0
	move.l  #0x00,	AccFlagX
	or.w	#0x0020, cier	
	rts				

	
	.globl	accreadY
accreadY:	
	cmpi.l  #0x01, AccFlagY
	beq	readokY

	move.l  #0xffffffff, d0
	rts

readokY:	
	clr.l	d0
	move.w	ch6par5, d0
	move.l  #0x00,	AccFlagY
	or.w	#0x0040, cier	
	rts				

	
	.globl	accrelease		
accrelease:	
	andi.w	#0xc3ff, cpr1		| stop channel 5,6
	andi.w	#0xff9f, cisr		| channel 5,6 interrupt not asserted
	andi.w	#0xff9f, cier		| disable further irq
	move.l  #0x00000000, AccFlagX
	move.l  #0x00000000, AccFlagY	
	rts	



