load data;
numAcc = 2;
numPlots = 8;
smooth = 10;
sideTilt = data(:,1);
frontTilt = data(:,2);
rFI = data(:,(numAcc+1)+4);
rFO = data(:,(numAcc+1)+5);
rBI = data(:,(numAcc+1)+6);
rBO = data(:,(numAcc+1)+7);
lFI = data(:,(numAcc+1)+1);
lFO = data(:,(numAcc+1)+0);
lBI = data(:,(numAcc+1)+3);
lBO = data(:,(numAcc+1)+2);
t = (0:12:(length(sideTilt) - 1) * 12);

figure(1);
plot(t,(sideTilt - 1023/2)/(1023/2),'b'), grid on, title('Side Tilt');
hold on;
delay = 0;
for i = 1:length(sideTilt)
  delay = delay + sideTilt(i);
  if i > smooth
    delay = delay - sideTilt(i - smooth);
  end
  sideTiltD(i) = delay/smooth;
end
plot(t,(sideTiltD - 1023/2)/(1023/2),'r');
rFoot = rFI|rFO|rBI|rBO;
lFoot = lFI|lFO|lBI|lBO;
plot(t, -1*rFoot + 0.5, 'g');
plot(t, -1*lFoot + 0.5, 'k');

figure(2);
plot(t,(frontTilt- 1023/2)/(1023/2)), grid on, title('Front Tilt');
hold on;
delay = 0;
for i = 1:length(frontTilt)
  delay = delay + frontTilt(i);
  if i > smooth
    delay = delay - frontTilt(i - smooth);
  end
  frontTiltD(i) = delay/smooth;
end
plot(t,(frontTiltD - 1023/2)/(1023/2),'r');
plot(t, -1*rFoot + 0.5, 'g');
plot(t, -1*lFoot + 0.5, 'k');


figure(3);
subplot(numPlots, 1, 1), plot(t,rFI), grid, title('Right Front Inner');
subplot(numPlots, 1, 2), plot(t,rFO), grid, title('Right Front Outer');
subplot(numPlots, 1, 3), plot(t,rBI), grid, title('Right Back Inner');
subplot(numPlots, 1, 4), plot(t,rBO), grid, title('Right Back Outer');
subplot(numPlots, 1, 5), plot(t,lFI), grid, title('Left Front Inner');
subplot(numPlots, 1, 6), plot(t,lFO), grid, title('Left Front Outer');
subplot(numPlots, 1, 7), plot(t,lBI), grid, title('Left Front Inner');
subplot(numPlots, 1, 8), plot(t,lBO), grid, title('Left Front Outer');


