/*

| ---------------------------------------------------------------------

| Filename: HDTRS.c

| 

|

| Description:

| -------

| HDT data for Biped Robot Rock Steady -----2002-A.Pickel

| ---------------------------------------------------------------------

*/



#define VERSION 1.0           /* User specific version nr. */

#define NAME "Biped"           /* Unique name max. 10 chars */

#define ID   10               /* Unique platform id (int)  */



#define LEG_LEFT  MOTOR_FR

#define MOTOR_LR  MOTOR_BL

#define LEG_RIGHT MOTOR_FL

/*#define NECK_   MOTOR_BR */



#define QUAD_LE QUAD_FR

#define QUAD_LR QUAD_BL

#define QUAD_RI QUAD_FL

/*#define QUAD_ QUAD_BR */





#include "hdt.h"

#include "hdt_sem.h"



/* The HDT structure */

/*-------------------*/

int     magic = 123456789;

extern HDT_entry_type HDT[];

HDT_entry_type  *hdtbase = &HDT[0];



#include "types.h"

#include "const.h"

#include "rs232.h"

#include "cam.h"

#include "librobi/librobi.h"









BYTE motconv0[101]={ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15,16,17,18,19,

                    20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,

                    40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,

                    60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,

                    80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,

                    100};



/* DC motors */

motor_type motor0 = {2,1, TIMER1, 16383, (void*)OutBase, 3, 2, (BYTE*)&motconv0};

motor_type motor1 = {2,0, TIMER1, 16383, (void*)OutBase, 0, 1, (BYTE*)&motconv0};

/*motor_type motor2 = {2,6, TIMER1, 16383, (void*)OutBase, 7, 5, (BYTE*)&motconv0};*/

motor_type motor2 = {2,7, TIMER1, 16383, (void*)OutBase, 6, 7, (BYTE*)&motconv0};

 



quad_type decoder0 = {0, 5, 4, MOTOR_FR, 27475, 2.0};

quad_type decoder1 = {0, 2, 3, MOTOR_FL, 27475, 2.0};

/*quad_type decoder2 = {0, 9, 8, MOTOR_BR, 27475, 2.0};*/

quad_type decoder2 = {0,10,11, MOTOR_BL, 27475, 2.0};



irtv_type irtv = {0, 12, TPU_HIGH_PRIO};





/* EyeBot SUMMARY */

info_type roboinfo  = {0,PLATFORM,SER115200,RTSCTS,SERIAL1,0,0,AUTOBRIGHTNESS,BATTERY_ON,33,VERSION,NAME,ID};



/* waitstates = 0..13, Fast Termination = 14, External = 15 */

/* Version, ROM, RAM, LCD, IO, Parallel+Serial2/3 */

/* 16MHz - 20Mhz */ /* waitstate_type waitstates = {0,3,0,1,0,2}; */

/* 21MHz - 41Mhz */    waitstate_type waitstates = {0,3,1,2,1,2};



/* include startup sound and image */

#include "startup.h"



HDT_entry_type HDT[] =

{

    {MOTOR,MOTOR_FR,"LEG-L",(void *)&motor0},

    {MOTOR,MOTOR_BL,"MOT-LR",(void *)&motor2},

    {MOTOR,MOTOR_FL,"LEG-R",(void *)&motor1},

   /* {MOTOR,MOTOR_BR,"NEC-LR",(void *)&motor2}, */

    

    {QUAD, QUAD_FR,"LEG-L",(void *)&decoder0},

    {QUAD, QUAD_BL,"MOT-LR",(void *)&decoder2},

    {QUAD, QUAD_FL,"LEG-R",(void *)&decoder1},

   /* {QUAD, QUAD_BR,"NEC-LR",(void *)&decoder2}, */

    

    {IRTV,IRTV,"IRTV",(void *)&irtv},



    

    {WAIT,WAIT,"WAIT",(void *)&waitstates},

    {INFO,INFO,"INFO",(void *)&roboinfo},



    

    {STARTMELODY,STARTMELODY,"Melody",(void *)startmelody},

    {STARTIMAGE,STARTIMAGE,"Image",(void *)&startimage},



    {END_OF_HDT,UNKNOWN_SEMANTICS,"END",(void *)0}

    

};

