/***************************************************************************/
/* sendData.c                                                              */
/* Collection of function send data to PC via RS232                        */
/* Author: Rich Chi Ooi                                                    */
/* Version: 1.0                                                            */
/* Date:30.05.2003                                                         */ 
/* -------------------------------                                         */
/* Compilation  procedure:                                                 */
/*       Linux                                                             */
/*      gcc68 -c  XXXXXX.c (to create object file)                         */
/*      gcc68 -o  XXXXXX.hex XXXXXX.o ppwa.o                               */
/***************************************************************************/
/* In this version:                                                        */
/***************************************************************************/

#include <stdlib.h>
#include "eyebot.h"
#include "sendData.h" 

/*
 *Sends a string to pc via RS232
 */
void sendString(char s[]){
  int i;
  i = 0;
  while (s[i] != 0){
    OSSendRS232(&s[i], SERIAL1);
    i++;
  }
}
/*
 *Sends characters back to the pc via RS232
 */
void sendCharacter(char character)
{
  int result;
  do
    {
      result = OSSendCharRS232(character, SERIAL1);
      if(result == 3)
	{
	  LCDClear();
	  LCDPrintf("Timeout error.\nRetrying...\n");
	  OSWait(50);
	  LCDClear();
	}
    } while(result == 3);
}

/*
 *Sends Integers to pc via RS232
 */
void sendInteger(int integer){
  int i;
  double temp;
  int last;
  
  /*Handle negative integers */
  if (integer < 0){
    sendCharacter('-'); 
    integer *= -1;
  }
  
  if (integer == 0){
    sendCharacter('0');
  }
  else{
    temp = integer + 0.1;
    
    i = 0;
    while( temp > 1){
      temp = temp / 10;
      i++;
    }
    temp = temp * 10;
    
    while (i > 0){
      last = temp;
      temp = (temp - last)* 10;
      sendCharacter( last + '0');
      i--;
    }
  } 
}
