/*



	GYRO.H



	Gyroscope class decyphers the gyroscope sensor installed on the balancing

	robot, Ballybot.



	If an analog inlinometer is installed on the robot, this class uses the

	inclinometer to recalibrate the gyro.



	Alistair Sutherland

	suthe-aj@ee.uwa.edu.au

	CIIPS, 2003



*/



extern "C"

{

#include "eyebot.h"

#include "ppwa.h"

}



// Error codes

#define GYRO_FAIL -1

#define GYRO_OK    0



// Modes of operation

// NORMAL_MODE : operate as a gyroscope, use inclinometer to recalibrate gyro

// DEBUG_RAW_MODE: no recalibratiton, record 1000 samples, then send them to RS232 port

#define NORMAL_MODE 0

#define DEBUG_RAW_MODE 1

#define DEBUG_ONLINE_MODE 2

#define GYRO_ONLY_MODE 3





#define DEBUG_RECORDING 1

#define DEBUG_NOTRECORDING 0



#define INIT_SAMPLES 50

#define INIT_DELAY 100

#define PI 3.14159



// AD Channel for Inclinometer

#define INCLINE_CHANNEL 2



// Prototypes...

int TransmitLine(char * sz);

int TransmitSample(int iTime, int iIncline, int iAngle, int iAngleVel);



////////////////////////////////////////////////

//

// GYRO

//

// Is a class wrapping the gyroscope sensor

//

class CGyro

{

public:

	CGyro();

	CGyro(int iMode);

	~CGyro();



	void InitialiseState();

	void Recalibrate();

	float GetAngle();

	float GetAngularVel();

	int GetTimeSinceCalibration();

	void DisplayAngularVelocity();

	void AdjustMaxAngle(int iGUnits);

	void DownloadData();

	void StopRecording();



protected:

	int m_iZeroVelocity;

	int m_iAngularVelocity;

	int m_iAngle;

	int m_iSampleTime;

	int m_iMaxAngle;

	int m_iZeroAngle;

	int m_iTimeLastCalibrated;

	TimerHandle m_hSampleTimer;

	ServoHandle m_hServo;

	void ZeroAngVel();

	int TransmitLine(char * sz);

};



