/*
* tpuregs.s - define addresses of TPU registers in 68332
* adjust the setting of tpumcr to reflect modmap bit
*/

tpumcr  =     0xfffffe00      | tpu module control register
tpucfg  =     tpumcr+2        | configuration register
dscr    =     tpumcr+4        | development support control register
dssr    =     tpumcr+6        | development support status register
tpuicr  =     tpumcr+8        | interrupt configuration register
tpuier  =     tpumcr+0xa      | interrupt enable register
cfsr0   =     tpumcr+0xc      | channel function select register 0 
cfsr1   =     tpumcr+0xe      | channel function select register 1
cfsr2   =     tpumcr+0x10     | channel function select register 2
cfsr3   =     tpumcr+0x12     | channel function select register 3
hsr0    =     tpumcr+0x14     | host sequence register 0
hsr1    =     tpumcr+0x16     | host sequence register 1
hsrr0   =     tpumcr+0x18     | host service request register 0
hsrr1   =     tpumcr+0x1a     | host service request register 1
cpr0    =     tpumcr+0x1c     | channel priority register 0
cpr1    =     tpumcr+0x1e     | channel priority register 1
tpuisr  =     tpumcr+0x20     | interrupt status register
link    =     tpumcr+0x22
sglr    =     tpumcr+0x24     | service grant latch register
dcnr    =     tpumcr+0x26     | decoded channel number register
tpupram =     tpumcr+0x100    | start of tpu parameter RAM

ticr	=     tpuicr
cier	=     tpuier
hsqr0	=     hsr0
hsqr1	=     hsr1
cisr	=     tpuisr

tpu5int =     0x154
tpu6int =     0x158
tpu7int =     0x15c
tpu8int =	  0x160
tpu9int =	  0x164
tpu10int =    0x168
tpu11int =    0x16c
tpu12int =    0x170
tpu13int =    0x174

ch0par0 =     tpupram
ch0par1	=     tpupram+2
ch0par2	=     tpupram+4
ch0par3 =     tpupram+6
ch0par4 =     tpupram+8
ch0par5 =     tpupram+0xa

ch5par0 =     tpupram+0x50
ch5par1	=     tpupram+0x52
ch5par2	=     tpupram+0x54
ch5par3 =     tpupram+0x56
ch5par4 =     tpupram+0x58
ch5par5 =     tpupram+0x5a

ch6par0 =     tpupram+0x60
ch6par1	=     tpupram+0x62
ch6par2	=     tpupram+0x64
ch6par3 =     tpupram+0x66
ch6par4 =     tpupram+0x68
ch6par5 =     tpupram+0x6a

ch7par0 =     tpupram+0x70
ch7par1	=     tpupram+0x72
ch7par2	=     tpupram+0x74
ch7par3 =     tpupram+0x76
ch7par4 =     tpupram+0x78
ch7par5 =     tpupram+0x7a

ch13par0 =     tpupram+0xd0
ch13par1 =     tpupram+0xd2
ch13par2 =     tpupram+0xd4
ch13par3 =     tpupram+0xd6
ch13par4 =     tpupram+0xd8
ch13par5 =     tpupram+0xda


