/* ---------------------------------------------------------------------------
| Filename:     memo.c
|
| Authors:      Thomas Braunl   
|
| Description:  find the mines
| ------------------------------------------------------------------------- */

#include "eyebot.h"
#include <stdlib.h>

#define TFAC  200
#define TOFF  100
#define TLEN  200
#define MROUND 20
#define WTIME  50

int main()
{ int round,j,k,err; 
  int seq[MROUND];

  LCDPutString("MEMO-RIZE\n");
  
  /* generate random sequence */
  for (k=0; k<MROUND; k++) seq[k] = 1 + rand() % 4;

  round = 1;
  do {
    if (round==6) LCDPutString("no more clues!\n");
    LCDPrintf("round %2d", round);

    for (k=0; k<round; k++)
    { OSWait(WTIME);
      if (round<=5) LCDMenuI(seq[k],"MEMO");
      AUTone(seq[k]*TFAC+TOFF, TLEN); /* sound output */
      while (!AUCheckTone()) /* wait */ ;
      LCDMenu(" "," "," "," "); 
    }

    LCDPutString("-repeat\n");
    err = 0;
    k = 0;
    do
    { j = KEYGet();
      if (j==KEY1) j=1; else if(j==KEY2) j=2; else if (j==KEY3) j=3; else j=4;
      if (j == seq[k])
      { AUTone(seq[k]*TFAC+TOFF, TLEN); /* sound output */
        while (!AUCheckTone()) /* wait */ ;
        k++;
      }
      else /* error */
      { AUBeep(); /* error tone */
        LCDMenuI(j,"ERR");
        err=1;
      }
    } while ((k<round) && (!err));

    if (!err) 
    { AUBeep(); AUBeep(); /* OK tone */
      round++;
    }
    OSWait(150);
    LCDMenu(" "," "," "," "); 
  } while (round<=MROUND);
 
  LCDClear();
  LCDPutString("MEMO-RIZE\nCONGRATULATIONS!");
  LCDMenu(" "," "," ","END");
  KEYGet();
  return 0;
}

