/* ----------------------------------------------------------------- */
/* Eyebot MIC-demo by Klaus Schmitt  (k_schmit@informatik.uni-kl.de) */
/*                                            last changes: 19/05/97 */
/* ----------------------------------------------------------------- */
/* This program displays graphically the values of the Microphone    */
/* Furthermore it prints the corresponding value                     */
/* ----------------------------------------------------------------- */

#include "eyebot.h"

int main ()
{
	int disttab[32];
	int pointer=0;
	int i,j;
	int val;

	/* clear the graphic-array */
	for(i=0; i<32; i++)
	{
	  disttab[i]=0;
	}

   	LCDSetPos(0,3);
	LCDPrintf("MIC-Demo");

	LCDMenu("","","","END");
	
	while (KEYRead() != KEY4)
	{
	  /* get actual data and scale it for the LCD */
	  disttab[pointer] = 64 - ((val=AUCaptureMic()) >> 4);

	  /* draw graphics */
	  for(i=0; i<32; i++)
	  {
	    j = (i+pointer)%32;
            LCDLine(i,disttab[j], i+4,disttab[(j+1)%32], 1);
	  }

	  /* print actual distance and raw-data */
	  LCDSetPos(7,0);
	  LCDPrintf("AD0:%3X",val);

	  /* clear LCD */
	  for(i=0; i<32; i++)
	  {
	    j = (i+pointer)%32;
            LCDLine(i,disttab[j], i+4,disttab[(j+1)%32], 0);
	  }

	  /* scroll the graphics */
	  pointer = (pointer+1)%32;
        }
  return 0;
}


