/*---------------------------------------------------------------------------
| Filename: timer.c
|
| Klaus Schmitt
|
| Description: 
| Timer-IRQ test
| ------------------------------------------------------------------------- */

#include "eyebot.h"

/* TimerFnc */
int count[3];

void counter1(void)
{
    count[0]++;
}
void counter2(void)
{
    count[1] += 2;
}
void counter3(void)
{
    count[2] += 3;
}


int main()
{
  TimerHandle handle[3];
  int  assigned[3];
  int  i;
  char k;

  /** set display mode */
  for(i=0;i<3;i++)
  {
    count[i]=0;
    assigned[i]=1;
  }
  LCDMode(NONSCROLLING|NOCURSOR);
  LCDMenu("Ir1","Ir2","Ir3","END");

  LCDPrintf("---Timer IRQs---\n");

  handle[0] = OSAttachTimer(1, counter1);
  handle[1] = OSAttachTimer(2, counter2);
  handle[2] = OSAttachTimer(3, counter3);

  while(KEY4 != (k=KEYRead())) 
  {
    LCDSetPos(2,0);
    for(i=0;i<3;i++)
        LCDPrintf("Counter%d: %d\n",i+1,count[i]);  
    switch (k) {
      case KEY1: 
            if(assigned[0])
            {
              OSDetachTimer(handle[0]);
              assigned[0] = 0;
            }
            else
            {
              handle[0] = OSAttachTimer(1, counter1);
              assigned[0] = 1;
            }
            break;
      case KEY2:
            if(assigned[1])
            {
              OSDetachTimer(handle[1]);
              assigned[1] = 0;
            }
            else
            {
              handle[1] = OSAttachTimer(2, counter2);
              assigned[1] = 1;
            }
            break;
      case KEY3:
            if(assigned[2])
            {
              OSDetachTimer(handle[2]);
              assigned[2] = 0;
            }
            else
            {
              handle[2] = OSAttachTimer(3, counter3);
              assigned[2] = 1;
            }
            break;
    }
  }

  for(i=0;i<3;i++)
  {
      if(assigned[i])
      {
        OSDetachTimer(handle[i]);
      }
  }
  return 0;
}

